/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.repl;

import com.cloudera.livy.Logging;
import com.cloudera.livy.client.common.ClientConf;
import com.cloudera.livy.repl.Interpreter;
import com.cloudera.livy.repl.PythonInterpreter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import py4j.GatewayServer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class PythonInterpreter$
implements Logging {
    public static final PythonInterpreter$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PythonInterpreter$();
    }

    private Logger logger$lzycompute() {
        PythonInterpreter$ pythonInterpreter$ = this;
        synchronized (pythonInterpreter$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public Interpreter apply(SparkConf conf) {
        String pythonExec = (String)package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "python";
            }
        });
        GatewayServer gatewayServer = new GatewayServer(null, 0);
        gatewayServer.start();
        ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pythonExec, this.createFakeShell().toString()}))).asJava());
        Map<String, String> env = builder.environment();
        String[] pythonPath = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).split(File.pathSeparator)).$plus$plus(ClientConf.TEST_MODE ? Nil$.MODULE$ : this.findPySparkArchives(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus(ClientConf.TEST_MODE ? Nil$.MODULE$ : this.findPyFiles(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        env.put("PYTHONPATH", Predef$.MODULE$.refArrayOps((Object[])pythonPath).mkString(File.pathSeparator));
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("SPARK_HOME", (String)package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ".";
            }
        }));
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = builder.start();
        return new PythonInterpreter(process, gatewayServer);
    }

    private Seq<String> findPySparkArchives() {
        return (Seq)package$.MODULE$.env().get((Object)"PYSPARK_ARCHIVES_PATH").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(",")).toSeq();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply() {
                return (Seq)package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(String sparkHome) {
                        String pyLibPath = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sparkHome, "python", "lib"}))).mkString(File.separator);
                        File pyArchivesFile = new File(pyLibPath, "pyspark.zip");
                        Predef$.MODULE$.require(pyArchivesFile.exists(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "pyspark.zip not found; cannot run pyspark application in YARN mode.";
                            }
                        });
                        File py4jFile = Files.newDirectoryStream(Paths.get(pyLibPath, new String[0]), "py4j-*-src.zip").iterator().next().toFile();
                        Predef$.MODULE$.require(py4jFile.exists(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "py4j-*-src.zip not found; cannot run pyspark application in YARN mode.";
                            }
                        });
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pyArchivesFile.getAbsolutePath(), py4jFile.getAbsolutePath()}));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                });
            }
        });
    }

    private Seq<String> findPyFiles() {
        String[] pyFiles = ((String)package$.MODULE$.props().getOrElse((Object)"spark.submit.pyFiles", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).split(",");
        Object object = package$.MODULE$.env().getOrElse((Object)"SPARK_YARN_MODE", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String string = "true";
        return !(object != null ? !object.equals(string) : string != null) ? (Seq)Predef$.MODULE$.refArrayOps((Object[])pyFiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String file) {
                String name = new File(file).getName();
                return new File(name).getAbsolutePath();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())) : Predef$.MODULE$.wrapRefArray((Object[])pyFiles);
    }

    /*
     * WARNING - void declaration
     */
    private File createFakeShell() {
        void var2_2;
        InputStream source = this.getClass().getClassLoader().getResourceAsStream("fake_shell.py");
        File file = Files.createTempFile("", "", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        FileOutputStream sink = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int n = source.read(buf);
        while (n > 0) {
            sink.write(buf, 0, n);
            n = source.read(buf);
        }
        source.close();
        sink.close();
        return var2_2;
    }

    private PythonInterpreter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

