/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc.driver;

import com.cloudera.livy.Job;
import com.cloudera.livy.JobContext;
import com.cloudera.livy.rsc.driver.MutableClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AddJarJob
implements Job<Object> {
    private final String path;

    private AddJarJob() {
        this(null);
    }

    public AddJarJob(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(JobContext jc) throws Exception {
        File localCopyDir = new File(jc.getLocalTmpDir(), "__livy__");
        JobContext jobContext = jc;
        synchronized (jobContext) {
            if (!localCopyDir.isDirectory() && !localCopyDir.mkdir()) {
                throw new IOException("Failed to create directory for downloaded jars.");
            }
        }
        URI uri = new URI(this.path);
        String name = uri.getFragment() != null ? uri.getFragment() : uri.getPath();
        name = new File(name).getName();
        File localCopy = new File(localCopyDir, name);
        if (localCopy.exists()) {
            throw new IOException(String.format("A file with name %s has already been uploaded.", name));
        }
        Configuration conf = jc.sc().sc().hadoopConfiguration();
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        fs.copyToLocalFile(new Path(uri), new Path(localCopy.toURI()));
        MutableClassLoader cl = (MutableClassLoader)Thread.currentThread().getContextClassLoader();
        cl.addURL(localCopy.toURI().toURL());
        jc.sc().addJar(this.path);
        return null;
    }
}

