/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc.driver;

import com.cloudera.livy.JobHandle;
import com.cloudera.livy.rsc.BypassJobStatus;
import com.cloudera.livy.rsc.Utils;
import com.cloudera.livy.rsc.driver.BypassJob;
import com.cloudera.livy.rsc.driver.JobWrapper;
import com.cloudera.livy.rsc.driver.RSCDriver;
import java.util.List;

class BypassJobWrapper
extends JobWrapper<byte[]> {
    private volatile byte[] result;
    private volatile Throwable error;
    private volatile JobHandle.State state = JobHandle.State.QUEUED;
    private volatile List<Integer> newSparkJobs;

    BypassJobWrapper(RSCDriver driver, String jobId, byte[] serializedJob) {
        super(driver, jobId, new BypassJob(driver.serializer(), serializedJob));
    }

    @Override
    public Void call() throws Exception {
        this.state = JobHandle.State.STARTED;
        return super.call();
    }

    @Override
    protected synchronized void finished(byte[] result, Throwable error) {
        if (error == null) {
            this.result = result;
            this.state = JobHandle.State.SUCCEEDED;
        } else {
            this.error = error;
            this.state = JobHandle.State.FAILED;
        }
    }

    @Override
    boolean cancel() {
        if (super.cancel()) {
            this.state = JobHandle.State.CANCELLED;
            return true;
        }
        return false;
    }

    @Override
    protected void jobStarted() {
    }

    synchronized BypassJobStatus getStatus() {
        String stackTrace = this.error != null ? Utils.stackTraceAsString(this.error) : null;
        return new BypassJobStatus(this.state, this.result, stackTrace);
    }
}

