/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.livy.rsc.driver;

import com.cloudera.livy.rsc.RSCConf;
import com.cloudera.livy.rsc.driver.RSCDriver;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.spark.SparkConf;

public final class RSCDriverBootstrapper {
    public static void main(String[] args) throws Exception {
        Properties props;
        switch (args.length) {
            case 0: {
                props = System.getProperties();
                break;
            }
            case 1: {
                props = new Properties();
                try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(args[0]), StandardCharsets.UTF_8);){
                    props.load(r);
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Too many arguments.");
            }
        }
        SparkConf conf = new SparkConf(false);
        RSCConf livyConf = new RSCConf(null);
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            if (key.startsWith("spark.__livy__.")) {
                livyConf.set(key.substring("spark.__livy__.".length()), value);
                continue;
            }
            if (!key.startsWith("spark.")) continue;
            conf.set(key, value);
        }
        String driverClass = livyConf.get(RSCConf.Entry.DRIVER_CLASS);
        if (driverClass == null) {
            driverClass = RSCDriver.class.getName();
        }
        RSCDriver driver = (RSCDriver)((Object)Thread.currentThread().getContextClassLoader().loadClass(driverClass).getConstructor(SparkConf.class, RSCConf.class).newInstance(conf, livyConf));
        driver.run();
    }
}

