/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.AirwideIA5Charset;
import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.GSMCharset;
import com.cloudhopper.commons.charset.ISO885915Charset;
import com.cloudhopper.commons.charset.ISO88591Charset;
import com.cloudhopper.commons.charset.ModifiedUTF8Charset;
import com.cloudhopper.commons.charset.PackedGSMCharset;
import com.cloudhopper.commons.charset.UCS2Charset;
import com.cloudhopper.commons.charset.UTF8Charset;
import com.cloudhopper.commons.charset.VFD2GSMCharset;
import com.cloudhopper.commons.charset.VFTRGSMCharset;
import java.util.HashMap;

public class CharsetUtil {
    public static final HashMap<String, Charset> charsets;
    public static final String NAME_ISO_8859_1 = "ISO-8859-1";
    public static final String NAME_ISO_8859_15 = "ISO-8859-15";
    public static final String NAME_GSM = "GSM";
    public static final String NAME_PACKED_GSM = "PACKED-GSM";
    public static final String NAME_UCS_2 = "UCS-2";
    public static final String NAME_UTF_8 = "UTF-8";
    public static final String NAME_MODIFIED_UTF8 = "MODIFIED-UTF8";
    public static final String NAME_AIRWIDE_IA5 = "AIRWIDE-IA5";
    public static final String NAME_VFD2_GSM = "VFD2-GSM";
    public static final String NAME_VFTR_GSM = "VFTR-GSM";
    public static final String NAME_GSM7 = "GSM7";
    public static final String NAME_GSM8 = "GSM8";
    public static final String NAME_AIRWIDE_GSM = "AIRWIDE-GSM";
    public static final Charset CHARSET_ISO_8859_1;
    public static final Charset CHARSET_ISO_8859_15;
    public static final Charset CHARSET_GSM;
    public static final Charset CHARSET_PACKED_GSM;
    public static final Charset CHARSET_UCS_2;
    public static final Charset CHARSET_UTF_8;
    public static final Charset CHARSET_MODIFIED_UTF8;
    public static final Charset CHARSET_AIRWIDE_IA5;
    public static final Charset CHARSET_VFD2_GSM;
    public static final Charset CHARSET_VFTR_GSM;
    public static final Charset CHARSET_GSM7;
    public static final Charset CHARSET_GSM8;
    public static final Charset CHARSET_AIRWIDE_GSM;

    public static HashMap<String, Charset> getCharsetMap() {
        return charsets;
    }

    public static Charset map(String charsetName) {
        String upperCharsetName = charsetName.toUpperCase();
        return charsets.get(upperCharsetName);
    }

    public static byte[] encode(CharSequence str0, String charsetName) {
        Charset charset = CharsetUtil.map(charsetName);
        if (charset == null) {
            return null;
        }
        return CharsetUtil.encode(str0, charset);
    }

    public static byte[] encode(CharSequence str0, Charset charset) {
        return charset.encode(str0);
    }

    public static void decode(byte[] bytes, StringBuilder buffer, String charsetName) {
        Charset charset = CharsetUtil.map(charsetName);
        if (charset == null) {
            return;
        }
        CharsetUtil.decode(bytes, buffer, charset);
    }

    public static void decode(byte[] bytes, StringBuilder buffer, Charset charset) {
        charset.decode(bytes, buffer);
    }

    public static String decode(byte[] bytes, String charsetName) {
        Charset charset = CharsetUtil.map(charsetName);
        if (charset == null) {
            return null;
        }
        return charset.decode(bytes);
    }

    public static String decode(byte[] bytes, Charset charset) {
        return charset.decode(bytes);
    }

    public static String normalize(CharSequence str0, String charsetName) {
        Charset charset = CharsetUtil.map(charsetName);
        if (charset == null) {
            throw new IllegalArgumentException("Unsupported charset [" + charsetName + "]");
        }
        return CharsetUtil.normalize(str0, charset);
    }

    public static String normalize(CharSequence str0, Charset charset) {
        return charset.normalize(str0);
    }

    static {
        CHARSET_ISO_8859_1 = new ISO88591Charset();
        CHARSET_ISO_8859_15 = new ISO885915Charset();
        CHARSET_GSM = new GSMCharset();
        CHARSET_PACKED_GSM = new PackedGSMCharset();
        CHARSET_UCS_2 = new UCS2Charset();
        CHARSET_UTF_8 = new UTF8Charset();
        CHARSET_MODIFIED_UTF8 = new ModifiedUTF8Charset();
        CHARSET_AIRWIDE_IA5 = new AirwideIA5Charset();
        CHARSET_VFD2_GSM = new VFD2GSMCharset();
        CHARSET_VFTR_GSM = new VFTRGSMCharset();
        CHARSET_GSM7 = CHARSET_PACKED_GSM;
        CHARSET_GSM8 = CHARSET_GSM;
        CHARSET_AIRWIDE_GSM = CHARSET_AIRWIDE_IA5;
        charsets = new HashMap();
        charsets.put(NAME_ISO_8859_1, CHARSET_ISO_8859_1);
        charsets.put(NAME_ISO_8859_15, CHARSET_ISO_8859_15);
        charsets.put(NAME_GSM, CHARSET_GSM);
        charsets.put(NAME_MODIFIED_UTF8, CHARSET_MODIFIED_UTF8);
        charsets.put(NAME_PACKED_GSM, CHARSET_PACKED_GSM);
        charsets.put(NAME_UCS_2, CHARSET_UCS_2);
        charsets.put(NAME_UTF_8, CHARSET_UTF_8);
        charsets.put(NAME_AIRWIDE_IA5, CHARSET_AIRWIDE_IA5);
        charsets.put(NAME_VFD2_GSM, CHARSET_VFD2_GSM);
        charsets.put(NAME_VFTR_GSM, CHARSET_VFTR_GSM);
        charsets.put(NAME_GSM7, CHARSET_GSM7);
        charsets.put(NAME_GSM8, CHARSET_GSM8);
        charsets.put(NAME_AIRWIDE_GSM, CHARSET_AIRWIDE_GSM);
    }
}

