/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.charset;

import com.cloudhopper.commons.charset.BaseCharset;
import com.cloudhopper.commons.util.FastByteArrayOutputStream;
import java.io.IOException;

public class GSMCharset
extends BaseCharset {
    public static final int EXTENDED_ESCAPE = 27;
    public static final int PAGE_BREAK = 10;
    public static final char[] CHAR_TABLE = new char[]{'@', '\u00a3', '$', '\u00a5', '\u00e8', '\u00e9', '\u00f9', '\u00ec', '\u00f2', '\u00c7', '\n', '\u00d8', '\u00f8', '\r', '\u00c5', '\u00e5', '\u0394', '_', '\u03a6', '\u0393', '\u039b', '\u03a9', '\u03a0', '\u03a8', '\u03a3', '\u0398', '\u039e', ' ', '\u00c6', '\u00e6', '\u00df', '\u00c9', ' ', '!', '\"', '#', '\u00a4', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '\u00a1', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00d1', '\u00dc', '\u00a7', '\u00bf', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00f1', '\u00fc', '\u00e0'};
    public static final char[] EXT_CHAR_TABLE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '^', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '{', '}', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\\', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '[', '~', ']', '\u0000', '|', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u20ac', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};

    public static boolean canRepresent(CharSequence str0) {
        if (str0 == null) {
            return true;
        }
        int len = str0.length();
        block3: for (int i = 0; i < len; ++i) {
            char c = str0.charAt(i);
            if (c >= ' ' && c <= '_' || c >= 'a' && c <= '~') continue;
            switch (c) {
                case '\n': 
                case '\r': 
                case '\u00a1': 
                case '\u00a3': 
                case '\u00a4': 
                case '\u00a5': 
                case '\u00a7': 
                case '\u00bf': 
                case '\u00c4': 
                case '\u00c5': 
                case '\u00c6': 
                case '\u00c7': 
                case '\u00c9': 
                case '\u00d1': 
                case '\u00d6': 
                case '\u00d8': 
                case '\u00dc': 
                case '\u00df': 
                case '\u00e0': 
                case '\u00e4': 
                case '\u00e5': 
                case '\u00e6': 
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ec': 
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f6': 
                case '\u00f8': 
                case '\u00f9': 
                case '\u00fc': 
                case '\u0393': 
                case '\u0394': 
                case '\u0398': 
                case '\u039b': 
                case '\u039e': 
                case '\u03a0': 
                case '\u03a3': 
                case '\u03a6': 
                case '\u03a8': 
                case '\u03a9': 
                case '\u20ac': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int estimateEncodeByteLength(CharSequence str0) {
        if (str0 == null) {
            return 0;
        }
        return str0.length() + 10;
    }

    @Override
    public byte[] encode(CharSequence str0) {
        if (str0 == null) {
            return null;
        }
        int estimatedByteLength = this.estimateEncodeByteLength(str0);
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(estimatedByteLength);
        try {
            int len = str0.length();
            for (int i = 0; i < len; ++i) {
                int search;
                char c = str0.charAt(i);
                for (search = 0; search < CHAR_TABLE.length; ++search) {
                    if (search == 27) continue;
                    if (c == CHAR_TABLE[search]) {
                        baos.write(search);
                        break;
                    }
                    if (c != EXT_CHAR_TABLE[search]) continue;
                    baos.write(27);
                    baos.write(search);
                    break;
                }
                if (search != CHAR_TABLE.length) continue;
                baos.write(63);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible error with FastByteArrayOutputStream: " + e.getMessage(), e);
        }
        return baos.toByteArray();
    }

    @Override
    public int estimateDecodeCharLength(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        if (bytes.length < 2) {
            return bytes.length;
        }
        return bytes.length + 10;
    }

    @Override
    public void decode(byte[] bytes, StringBuilder buffer) {
        if (bytes == null) {
            return;
        }
        char[] table = CHAR_TABLE;
        for (int i = 0; i < bytes.length; ++i) {
            int code = bytes[i] & 0xFF;
            if (code == 27) {
                table = EXT_CHAR_TABLE;
                continue;
            }
            buffer.append(code >= table.length ? (char)'?' : table[code]);
            table = CHAR_TABLE;
        }
    }
}

