/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.gsm;

import com.cloudhopper.commons.util.HexUtil;

public class DataCoding {
    public static final byte MESSAGE_CLASS_0 = 0;
    public static final byte MESSAGE_CLASS_1 = 1;
    public static final byte MESSAGE_CLASS_2 = 2;
    public static final byte MESSAGE_CLASS_3 = 3;
    public static final byte CHAR_ENC_DEFAULT = 0;
    public static final byte CHAR_ENC_IA5 = 1;
    public static final byte CHAR_ENC_8BITA = 2;
    public static final byte CHAR_ENC_LATIN1 = 3;
    public static final byte CHAR_ENC_8BIT = 4;
    public static final byte CHAR_ENC_JIS = 5;
    public static final byte CHAR_ENC_CYRLLIC = 6;
    public static final byte CHAR_ENC_HEBREW = 7;
    public static final byte CHAR_ENC_UCS2 = 8;
    public static final byte CHAR_ENC_PICTO = 9;
    public static final byte CHAR_ENC_MUSIC = 10;
    public static final byte CHAR_ENC_RSRVD = 11;
    public static final byte CHAR_ENC_RSRVD2 = 12;
    public static final byte CHAR_ENC_EXKANJI = 13;
    public static final byte CHAR_ENC_KSC5601 = 14;
    public static final byte CHAR_ENC_RSRVD3 = 15;
    private final byte dcs;
    private final Group codingGroup;
    private final byte characterEncoding;
    private final byte messageClass;
    private final boolean compressed;

    protected DataCoding(byte dcs, Group codingGroup, byte characterEncoding, byte messageClass, boolean compressed) {
        this.dcs = dcs;
        this.codingGroup = codingGroup;
        this.characterEncoding = characterEncoding;
        this.messageClass = messageClass;
        this.compressed = compressed;
    }

    public byte getByteValue() {
        return this.dcs;
    }

    public Group getCodingGroup() {
        return this.codingGroup;
    }

    public byte getCharacterEncoding() {
        return this.characterEncoding;
    }

    public byte getMessageClass() {
        return this.messageClass;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public static DataCoding createCharacterEncodingGroup(byte characterEncoding) throws IllegalArgumentException {
        if ((characterEncoding & 0xF0) != 0) {
            throw new IllegalArgumentException("Invalid characterEncoding [0x" + HexUtil.toHexString((byte)characterEncoding) + "] value used: only 16 possible for char encoding group");
        }
        return new DataCoding(characterEncoding, Group.CHARACTER_ENCODING, characterEncoding, 0, false);
    }

    public static DataCoding createMessageClassGroup(byte characterEncoding, byte messageClass) throws IllegalArgumentException {
        if (characterEncoding != 0 && characterEncoding != 4) {
            throw new IllegalArgumentException("Invalid characterEncoding [0x" + HexUtil.toHexString((byte)characterEncoding) + "] value used: only default or 8bit supported for message class group");
        }
        if (messageClass < 0 || messageClass > 3) {
            throw new IllegalArgumentException("Invalid messageClass [0x" + HexUtil.toHexString((byte)messageClass) + "] value used: 0x00-0x03 only valid range");
        }
        byte dcs = -16;
        if (characterEncoding == 4) {
            dcs = (byte)(dcs | 4);
        }
        dcs = (byte)(dcs | messageClass);
        return new DataCoding(dcs, Group.MESSAGE_CLASS, characterEncoding, messageClass, false);
    }

    public static DataCoding createGeneralGroup(byte characterEncoding, Byte messageClass, boolean compressed) throws IllegalArgumentException {
        if (characterEncoding != 0 && characterEncoding != 4 && characterEncoding != 8) {
            throw new IllegalArgumentException("Invalid characterEncoding [0x" + HexUtil.toHexString((byte)characterEncoding) + "] value used: only default, 8bit, or UCS2 supported for general group");
        }
        if (messageClass != null && (messageClass < 0 || messageClass > 3)) {
            throw new IllegalArgumentException("Invalid messageClass [0x" + HexUtil.toHexString((byte)messageClass) + "] value used: 0x00-0x03 only valid range");
        }
        byte dcs = 0;
        if (compressed) {
            dcs = (byte)(dcs | 0x20);
        }
        if (messageClass != null) {
            dcs = (byte)(dcs | 0x10);
            dcs = (byte)(dcs | messageClass);
        }
        dcs = (byte)(dcs | characterEncoding);
        return new DataCoding(dcs, Group.GENERAL, characterEncoding, messageClass == null ? (byte)0 : messageClass, compressed);
    }

    public static DataCoding createMessageWaitingIndicationGroup(byte characterEncoding, boolean store, boolean active, byte indicatorType) throws IllegalArgumentException {
        if (characterEncoding != 0 && characterEncoding != 8) {
            throw new IllegalArgumentException("Invalid characterEncoding [0x" + HexUtil.toHexString((byte)characterEncoding) + "] value used: only default or UCS2 supported for MWI group");
        }
        if (indicatorType < 0 || indicatorType > 3) {
            throw new IllegalArgumentException("Invalid indicatorType [0x" + HexUtil.toHexString((byte)indicatorType) + "] value used: 0x00-0x03 only valid range");
        }
        byte dcs = -64;
        if (characterEncoding == 8) {
            dcs = (byte)(dcs | 0x20);
        }
        if (store) {
            dcs = (byte)(dcs | 0x10);
        }
        if (active) {
            dcs = (byte)(dcs | 8);
        }
        dcs = (byte)(dcs | indicatorType);
        return new DataCoding(dcs, Group.MESSAGE_WAITING_INDICATION, characterEncoding, 0, false);
    }

    public static DataCoding createReservedGroup(byte dcs) {
        return new DataCoding(dcs, Group.RESERVED, 0, 0, false);
    }

    public static DataCoding parse(byte dcs) {
        try {
            if ((dcs & 0xFFFFFFF0) == 0) {
                return DataCoding.createCharacterEncodingGroup(dcs);
            }
            if ((dcs & 0xFFFFFFF0) == -16) {
                byte characterEncoding = 0;
                if ((dcs & 4) == 4) {
                    characterEncoding = 4;
                }
                byte messageClass = (byte)(dcs & 3);
                return DataCoding.createMessageClassGroup(characterEncoding, messageClass);
            }
            if ((dcs & 0xFFFFFFC0) == 0) {
                boolean compressed = false;
                if ((dcs & 0x20) == 32) {
                    compressed = true;
                }
                byte tempMessageClass = (byte)(dcs & 3);
                Byte messageClass = null;
                if ((dcs & 0x10) == 16) {
                    messageClass = new Byte(tempMessageClass);
                }
                byte characterEncoding = (byte)(dcs & 0xC);
                return DataCoding.createGeneralGroup(characterEncoding, messageClass, compressed);
            }
            if ((dcs & 0xFFFFFFC0) == -64) {
                byte characterEncoding = 0;
                if ((byte)(dcs & 0x20) == 32) {
                    characterEncoding = 8;
                }
                boolean store = false;
                if ((byte)(dcs & 0x10) == 16) {
                    store = true;
                }
                boolean indicatorActive = false;
                if ((byte)(dcs & 8) == 8) {
                    indicatorActive = true;
                }
                byte indicatorType = (byte)(dcs & 3);
                return DataCoding.createMessageWaitingIndicationGroup(characterEncoding, store, indicatorActive, indicatorType);
            }
            return DataCoding.createReservedGroup(dcs);
        }
        catch (IllegalArgumentException e) {
            return DataCoding.createReservedGroup(dcs);
        }
    }

    public static enum Group {
        CHARACTER_ENCODING,
        GENERAL,
        MESSAGE_WAITING_INDICATION,
        MESSAGE_CLASS,
        RESERVED;

    }
}

