/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.gsm;

import com.cloudhopper.commons.util.ByteUtil;
import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.commons.util.StringUtil;

public class GsmUtil {
    public static byte[] toBcd(String address) throws NullPointerException, IllegalArgumentException {
        if (address == null) {
            throw new NullPointerException("Address cannot be null for BCD encoding");
        }
        if (!StringUtil.containsOnlyDigits((String)address)) {
            throw new IllegalArgumentException("Address must only contain digits");
        }
        if (address.length() % 2 != 0) {
            address = address + "F";
        }
        int bytes_len = address.length() / 2;
        byte[] bcd = new byte[bytes_len];
        for (int i = 0; i < bytes_len; ++i) {
            StringBuilder chunk = new StringBuilder(address.substring(i * 2, i * 2 + 2));
            chunk.reverse();
            byte[] bytes = HexUtil.toByteArray((CharSequence)chunk.toString());
            bcd[i] = bytes[0];
        }
        return bcd;
    }

    public static byte toSubmitInfo(boolean replyPath, boolean udhIndicator, boolean deliveryReceipt, int validityPeriodFormat, boolean rejectDuplicates) throws IllegalArgumentException {
        byte info = 0;
        if (replyPath) {
            info = (byte)(info | 0x80);
        }
        if (udhIndicator) {
            info = (byte)(info | 0x40);
        }
        if (deliveryReceipt) {
            info = (byte)(info | 0x20);
        }
        if (validityPeriodFormat == 1) {
            info = (byte)(info | 0x10);
        } else if (validityPeriodFormat == 2) {
            info = (byte)(info | 8);
        } else if (validityPeriodFormat == 3) {
            info = (byte)(info | 0x10);
            info = (byte)(info | 8);
        } else if (validityPeriodFormat != 0) {
            throw new IllegalArgumentException("Invalid validity period format");
        }
        if (rejectDuplicates) {
            info = (byte)(info | 4);
        }
        info = (byte)(info | 1);
        return info;
    }

    public static byte[] removeUserDataHeader(byte[] shortMessage) {
        return GsmUtil.getShortMessageUserData(shortMessage);
    }

    public static byte[] getShortMessageUserData(byte[] shortMessage) throws IllegalArgumentException {
        if (shortMessage == null) {
            return null;
        }
        if (shortMessage.length == 0) {
            return shortMessage;
        }
        int userDataHeaderLength = ByteUtil.decodeUnsigned((byte)shortMessage[0]) + 1;
        if (userDataHeaderLength > shortMessage.length) {
            throw new IllegalArgumentException("User data header length exceeds short message length [shortMessageLength=" + shortMessage.length + ", userDataHeaderLength=" + userDataHeaderLength + "]");
        }
        int newShortMessageLength = shortMessage.length - userDataHeaderLength;
        byte[] newShortMessage = new byte[newShortMessageLength];
        System.arraycopy(shortMessage, userDataHeaderLength, newShortMessage, 0, newShortMessageLength);
        return newShortMessage;
    }

    public static byte[] getShortMessageUserDataHeader(byte[] shortMessage) throws IllegalArgumentException {
        if (shortMessage == null) {
            return null;
        }
        if (shortMessage.length == 0) {
            return shortMessage;
        }
        int userDataHeaderLength = ByteUtil.decodeUnsigned((byte)shortMessage[0]) + 1;
        if (userDataHeaderLength > shortMessage.length) {
            throw new IllegalArgumentException("User data header length exceeds short message length [shortMessageLength=" + shortMessage.length + ", userDataHeaderLength=" + userDataHeaderLength + "]");
        }
        if (userDataHeaderLength == shortMessage.length) {
            return shortMessage;
        }
        byte[] userDataHeader = new byte[userDataHeaderLength];
        System.arraycopy(shortMessage, 0, userDataHeader, 0, userDataHeaderLength);
        return userDataHeader;
    }

    public static byte[][] createConcatenatedBinaryShortMessages(byte[] binaryShortMessage, byte referenceNum) throws IllegalArgumentException {
        if (binaryShortMessage == null) {
            return null;
        }
        if (binaryShortMessage.length <= 140) {
            return null;
        }
        int numParts = binaryShortMessage.length / 134 + (binaryShortMessage.length % 134 != 0 ? 1 : 0);
        byte[][] shortMessageParts = new byte[numParts][];
        for (int i = 0; i < numParts; ++i) {
            int shortMessagePartLength = 134;
            if (i + 1 == numParts) {
                shortMessagePartLength = binaryShortMessage.length - i * 134;
            }
            byte[] shortMessagePart = new byte[6 + shortMessagePartLength];
            shortMessagePart[0] = 5;
            shortMessagePart[1] = 0;
            shortMessagePart[2] = 3;
            shortMessagePart[3] = referenceNum;
            shortMessagePart[4] = (byte)numParts;
            shortMessagePart[5] = (byte)(i + 1);
            System.arraycopy(binaryShortMessage, i * 134, shortMessagePart, 6, shortMessagePartLength);
            shortMessageParts[i] = shortMessagePart;
        }
        return shortMessageParts;
    }
}

