package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.commons.util.NamingThreadFactory;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Simple factory for AsyncHttpClient. 
 * @author garth
 */
public class AsyncHttpClientFactory {

    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClientFactory.class);
    private final AsyncHttpClient http;

    public AsyncHttpClientFactory(int requestTimeout, int connectTimeout) {
        // Hey, Netty! Don't change our thread names!
        ThreadRenamingRunnable.setThreadNameDeterminer(ThreadNameDeterminer.CURRENT);

	logger.info("Building AsyncHttpClient factory with {}ms requestTimeout and {}ms connectTimeout", requestTimeout, connectTimeout);

    	AsyncHttpClientConfig.Builder httpConfigBuilder = new AsyncHttpClientConfig.Builder();
	httpConfigBuilder.setRequestTimeoutInMs(requestTimeout);
	httpConfigBuilder.setConnectionTimeoutInMs(connectTimeout);

        // Set the maximum time in millisecond an AsyncHttpClient will keep connection idle in pool:
	//   AsyncHttpClientConfig.Builder setIdleConnectionInPoolTimeoutInMs(int defaultIdleConnectionInPoolTimeoutInMs)
        // Set the maximum time in millisecond an AsyncHttpClient can stay idle:
	//   AsyncHttpClientConfig.Builder setIdleConnectionTimeoutInMs(int defaultIdleConnectionTimeoutInMs)

	// Override the Ning Async Client's reaper behavior
        ScheduledExecutorService reaper = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(),
									   new NamingThreadFactory("CHMQ-HttpClient-Reaper", true));
	httpConfigBuilder.setScheduledExecutorService(reaper);
	
	// Override the Ning Async Client's worker thread pool behavior
        ExecutorService applicationThreadPool = Executors.newFixedThreadPool((Runtime.getRuntime().availableProcessors() * 2)+1,
									     new NamingThreadFactory("CHMQ-HttpClient-Callback", true));
	httpConfigBuilder.setExecutorService(applicationThreadPool);
	httpConfigBuilder.setIOThreadMultiplier(2); //This is the default

	http = new AsyncHttpClient(httpConfigBuilder.build());
 
	// in the old Apache HTTP client 
        // - turn off TCP_NODELAY
        // - disable using http 100 expect
    }

    public AsyncHttpClient getClient() {
	return this.http;
    }

}
