package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.commons.util.URL;
import com.cloudhopper.commons.util.URLParser;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;

/**
 * Configuration of a Distributed Broker.
 * 
 * @author joelauer
 */
public class DistributedQueueConfiguration {

    public static final int DEFAULT_BROKER_ID = 0;
    public static final String DEFAULT_GROUP_NAME = "CloudhopperMQ";
    public static final int DEFAULT_AREA_ID = 0;
    public static final long DEFAULT_MONITOR_INTERVAL = 5000;               // 5 seconds
    public static final long DEFAULT_CONNECTION_TIMEOUT = 10000;            // 10 seconds
    public static final long DEFAULT_LOCAL_CONSUMER_FLAPPING_DELAY = 10000; // 10 seconds
    public static final long DEFAULT_LOCAL_QUEUE_CREATE_DELAY = 5000;       // 5 seconds
    public static final byte DEFAULT_MAX_TRANSFER_COUNT = 3;
    public static final byte DEFAULT_MAX_TRANSFER_ATTEMPTS_COUNT = 10;
    public static final int DEFAULT_MAX_CONCURRENT_REQEUSTS = 5;
    public static final int DEFAULT_REMOTING_REQUEST_THREADS = 4;
    public static final int DEFAULT_REMOTING_RESPONSE_THREADS = 4;
    public static final long DEFAULT_REMOTING_TAKE_TIMEOUT = 50l;

    // numeric identifier of the distributed queue -- needs to be unique in a network
    // helps to detect duplicate instances within the network
//    private int brokerId;
    // set of remote brokers we may forward items to
    private HashSet<URL> remoteBrokers;
    // name of "group" (safety precaution against development system, etc)
    private String groupName;
    // id of area (e.g. subgroup) (useful for multiple data centers)
    private Integer areaId;
    // number of threads to execute monitoring of remote brokers
    private int monitorThreads;
    // number of milliseconds between monitoring checks
    private long monitorInterval;
    // number of milliseconds for a timeout on a connection
    private long connectionTimeout;
    // number of milliseconds to delay processing when local consumers are gone
    private long localConsumerFlappingDelay;
    // number of milliseconds after a queue created to see if a remote queue handles it
    private long localQueueCreateDelay;
    // max "TransferCount" value a an "MQMessage" can have
    private byte maxTransferCount;
    // max "TransferAttemptsCount" value an "MQMessage" can have
    // this is reset to zero on a BrokerServer when it accepts an "MQMessage"
    private byte maxTransferAttemptsCount;
    // should we detect duplicate brokerIds in the network and treat them
    // as though they are unavailable
    //    private boolean detectDuplicateBrokerIds;
    // max concurrent requests that can be made by a LocalToRemoteQueueProcessor
    private int maxConcurrentRequests;
    // thread pool size for creating AsyncRemoteQueueTransfers
    private int remotingRequestThreads;
    // thread pool size for processing TransferResponseHandlers
    private int remotingResponseThreads;
    // timeout for LocalToRemoteQueueProcessor to wait on a queue take()
    private long remotingTakeTimeout;

    public DistributedQueueConfiguration() {
        // default settings
//        this.brokerId = DEFAULT_BROKER_ID;
        this.remoteBrokers = new HashSet<URL>();
        this.groupName = DEFAULT_GROUP_NAME;
        this.areaId = DEFAULT_AREA_ID;
        this.monitorThreads = 3;
        this.monitorInterval = DEFAULT_MONITOR_INTERVAL;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        this.localConsumerFlappingDelay = DEFAULT_LOCAL_CONSUMER_FLAPPING_DELAY;
        this.localQueueCreateDelay = DEFAULT_LOCAL_QUEUE_CREATE_DELAY;
        this.maxTransferCount = DEFAULT_MAX_TRANSFER_COUNT;
        this.maxTransferAttemptsCount = DEFAULT_MAX_TRANSFER_ATTEMPTS_COUNT;
//        this.detectDuplicateBrokerIds = true;
	this.maxConcurrentRequests = DEFAULT_MAX_CONCURRENT_REQEUSTS;
	this.remotingRequestThreads = DEFAULT_REMOTING_REQUEST_THREADS;
	this.remotingResponseThreads = DEFAULT_REMOTING_RESPONSE_THREADS;
	this.remotingTakeTimeout = DEFAULT_REMOTING_TAKE_TIMEOUT;
    }

/**
    public void setDetectDuplicateBrokerIds(boolean value) {
        this.detectDuplicateBrokerIds = value;
    }

    public boolean isDetectDuplicateBrokersIdsEnabled() {
        return this.detectDuplicateBrokerIds;
    }

    public void setBrokerId(int value) {
        this.brokerId = value;
    }

    public int getBrokerId() {
        return this.brokerId;
    }
*/
    public void setMaxConcurrentRequests(int value) {
	this.maxConcurrentRequests = value;
    }

    public int getMaxConcurrentRequests() {
	return this.maxConcurrentRequests;
    }

    public void setRemotingRequestThreads(int value) {
	this.remotingRequestThreads = value;
    }

    public int getRemotingRequestThreads() {
	return this.remotingRequestThreads;
    }

    public void setRemotingResponseThreads(int value) {
	this.remotingResponseThreads = value;
    }

    public int getRemotingResponseThreads() {
	return this.remotingResponseThreads;
    }

    public void setRemotingTakeTimeout(long value) {
	this.remotingTakeTimeout = value;
    }

    public long getRemotingTakeTimeout() {
	return this.remotingTakeTimeout;
    }

    public void setMaxTransferCount(byte value) {
        this.maxTransferCount = value;
    }

    public byte getMaxTransferCount() {
        return this.maxTransferCount;
    }

    public void setMaxTransferAttemptsCount(byte value) {
        this.maxTransferAttemptsCount = value;
    }

    public byte getMaxTransferAttemptsCount() {
        return this.maxTransferAttemptsCount;
    }

    public void setLocalConsumerFlappingDelay(long value) {
        this.localConsumerFlappingDelay = value;
    }

    public long getLocalConsumerFlappingDelay() {
        return this.localConsumerFlappingDelay;
    }

    public void setLocalQueueCreateDelay(long value) {
        this.localQueueCreateDelay = value;
    }

    public long getLocalQueueCreateDelay() {
        return this.localQueueCreateDelay;
    }

    public void setMonitorThreads(int value) {
        this.monitorThreads = value;
    }

    public int getMonitorThreads() {
        return this.monitorThreads;
    }

    public void setMonitorInterval(long value) {
        this.monitorInterval = value;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setConnectionTimeout(long value) {
        this.connectionTimeout = value;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setAreaId(Integer value) {
        this.areaId = value;
    }

    public Integer getAreaId() {
        return this.areaId;
    }

    public void setGroupName(String value) {
        this.groupName = value;
    }

    public String getGroupName() {
        return this.groupName;
    }

    /**
     * Adds a remote broker to our list.
     * @param value
     * @throws MalformedURLException
     */
    public void addRemoteBroker(String value) throws MalformedURLException, IllegalArgumentException {
        // always parse the value into a URL
        URL url = URLParser.parse(value);
        
        // do we already have this URL?
        if (remoteBrokers.contains(url)) {
            throw new IllegalArgumentException("Duplicate URL [" + value + "] cannot be configured");
        }
        
        this.remoteBrokers.add(url);
    }

    public URL[] getRemoteBrokers() {
        return this.remoteBrokers.toArray(new URL[0]);
    }
}
