package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

public interface DistributedQueueStateListener {

    //
    // RemoteBroker events
    //
    
    /**
     * Triggered when a RemoteBroker was added to the DistributedQueueState.
     * @param bi The RemoteBroker that was added
     */
    public void notifyRemoteBrokerAdded(RemoteBrokerInfo bi);

    /**
     * Triggered when a RemoteBroker was remove from the DistributedQueueState.
     * @param bi The RemoteBroker that was removed
     */
    public void notifyRemoteBrokerRemoved(RemoteBrokerInfo bi);

    /**
     * Triggered when the state of a RemoteBroker has changed in the DistributedQueueState.
     * This event will triggered AFTER any RemoteQueues this RemoteBroker was
     * associated with are triggered first.  For example, if the RemoteBroker
     * goes down (not available) and its the only RemoteBroker that can transfer
     * items to a RemoteQueue, then the RemoteQueueStateChanged event will occur
     * BEFORE this method is triggered.
     * @param bi The RemoteBroker whose state changed
     */
    public void notifyRemoteBrokerStateChanged(RemoteBrokerInfo bi, int state);

    //
    // RemoteQueue events
    //
    
    /**
     * Triggered when a RemoteQueue was added to the DistributedQueueState.
     * If the RemoteQueue was added as a result of state change (such as it becoming
     * available), then this event should happen BEFORE the notifyRemoteQueueStateChanged
     * event occurs.
     * @param qi The RemoteQueue that was added
     */
    public void notifyRemoteQueueAdded(RemoteQueueInfo qi);

    /**
     * Triggered when a RemoteQueue was removed from the DistributedQueueState.
     * @param qi The RemoteQueue that was removed
     */
    public void notifyRemoteQueueRemoved(RemoteQueueInfo qi);

    /**
     * Triggered when the state of a RemoteQueue has changed in the DistributedQueueState.
     * This is potentially the most important event to watch for in order to
     * start/stop distributors on a particular local queue.
     * @param qi The RemoteQueue whose state changed
     */
    public void notifyRemoteQueueStateChanged(RemoteQueueInfo qi, int state);

    /**
     * Triggered when just the internal attributes of a RemoteQueue has changed,
     * but not enough to affect the overall state of the RemoteQueue.  For example,
     * if there was already a RemoteBroker on the RemoteQueue, but a second one
     * came online.  That would trigger this event, but not cause a state change.
     * @param qi The RemoteQueue whose attributes changed
     */
    public void notifyRemoteQueueAttributesChanged(RemoteQueueInfo qi);

}
