package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Thrown when there are no more RemoteBrokers available. The action should be
 * to requeue the item, kill the remote queue processor, and have it only try
 * again at a future time when a monitor sees the queue as available again.
 * 
 * @author joelauer
 */
public class NoMoreRemoteBrokersException extends Exception {
    private static final long serialVersionUID = 1L;

    public NoMoreRemoteBrokersException(String msg) {
        super(msg);
    }

    public NoMoreRemoteBrokersException(String msg, Throwable t) {
        super(msg, t);
    }
}
