package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.io.IOException;
import java.util.Map;

import com.cloudhopper.mq.broker.protocol.MonitorResponse;
import com.cloudhopper.mq.broker.protocol.ProtocolFactory;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author joelauer
 */
public class RemoteBrokerMonitor implements Runnable {

    private static final Logger logger = LoggerFactory.getLogger(RemoteBrokerMonitor.class);
    private final DistributedQueueConfiguration configuration;
    private final DistributedQueueState state;
    private final RemoteBrokerInfo remoteBroker;
    private final AsyncHttpClientFactory httpFactory;

    public RemoteBrokerMonitor(DistributedQueueConfiguration configuration, DistributedQueueState state,
			       RemoteBrokerInfo remoteBroker, AsyncHttpClientFactory httpFactory) {
        this.configuration = configuration;
        this.state = state;
        this.remoteBroker = remoteBroker;
	this.httpFactory = httpFactory;
    }

    public RemoteBrokerInfo getRemoteBroker() {
        return this.remoteBroker;
    }

    public void run() {
	AsyncHttpClient http = httpFactory.getClient();

        // create the monitoring request
        // HttpGet get = RemoteBrokerHttpFactory.createMonitorRequest(remoteBroker.getUrl(), configuration.getGroupName(), -1);

        // create the final url with format group=<groupName>&cmd=monitor
        String cmdurl = remoteBroker.getUrl() + "?cmd=monitor";
        if (configuration.getGroupName() != null) {
            cmdurl += "&group=" + configuration.getGroupName();
        }

        // HttpEntity entity = null;
        long monitorTime = System.currentTimeMillis();
        
        try {
            logger.debug("Monitoring RemoteBroker availability @ " + cmdurl);

            // always update time it was monitored
            remoteBroker.setLastMonitorTime(monitorTime);

            // execute request and get response
	    //            HttpResponse httpResponse = http.execute(get);
	    Response response = http.prepareGet(cmdurl).execute().get();

            // check the http response - validate it was 200
            // throws an exception if it wasn't
            //HttpClientUtil.checkHttpResponseStatusCode(httpResponse);
	    //HttpClientUtil.expectStatusCode(HttpStatus.SC_OK, httpResponse);
	    if (response.getStatusCode() != 200) throw new RuntimeException("Unexpected status code "+response.getStatusCode());

            // at this point, we know there is a 200 status code, get the response entity
            //entity = httpResponse.getEntity();

            // if (entity == null) {
            //     throw new IOException("HttpResponse entity was null and a response was expected");
            // }

            // consume content and process it
	    //String body = EntityUtils.toString(entity);
            String body = response.getResponseBody();

            if (body == null) {
                throw new IOException("Response entity was null and a response was expected");
            }

            // time to parse the body
            MonitorResponse monitorResponse = ProtocolFactory.parseMonitorResponse(body);

            // update areaId first - this should really only happen the first time
            remoteBroker.setAreaId(monitorResponse.getAreaId());

            // update version - this should really only happen the first time
            remoteBroker.setVersion(monitorResponse.getVersion());

            // process the queues included with the result...
            for (Map.Entry<String,Integer> entry : monitorResponse.getQueues().entrySet()) {
                logger.debug("Received update for queueName=" + entry.getKey() + " with weight=" + entry.getValue());
                state.updateRemoteQueueWeight(entry.getKey(), remoteBroker.getUrl(), entry.getValue());
            }

            // assume its ok
            this.state.updateRemoteBrokerState(remoteBroker.getUrl(), RemoteBrokerInfo.STATE_AVAILABLE, "OK", monitorTime);
        } catch (Exception e) {
            logger.error("", e);
            this.state.updateRemoteBrokerState(remoteBroker.getUrl(), RemoteBrokerInfo.STATE_NOT_AVAILABLE, e.getMessage(), monitorTime);
        } finally {
            // if (entity != null) {
            //     try {
            //         entity.consumeContent();
            //     } catch (Exception e) {
            //         logger.error("Unable to cleanly consume content", e);
            //     }
            // }

            // // make sure to close all connections!
            // if (http != null) {
            //     http.getConnectionManager().shutdown();
            // }
        }
    }

}
