package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.mq.queue.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author garth
 */
public class RemotingCompletionHandler implements CompletionHandler
{
    private static final Logger logger = LoggerFactory.getLogger(RemotingCompletionHandler.class);

    public RemotingCompletionHandler(Queue queue,
				     FairRemoteQueueTransferScheduler scheduler)
    {
	this.queue = queue;
	this.scheduler = scheduler;
    }

    AtomicBoolean active = new AtomicBoolean(false);
    Queue queue;
    FairRemoteQueueTransferScheduler scheduler;
    AtomicInteger cnt = new AtomicInteger(0);
    boolean signalled = false; //should this be an AtomicBoolean? 

    public void onSuccess() {
	synchronized(active) {
	    int i = cnt.incrementAndGet();
	    if (i == 1 && !signalled) {
		signalled = true;
		logger.trace("[{}] Calling complete() after onSuccess()", queue.getName());
		scheduler.complete(queue);
	    }
	}
    }

    public void onFailure() {
	synchronized(active) {
	    int i = cnt.incrementAndGet();
	    if (i == 1 && !signalled) {
		signalled = true;
		logger.trace("[{}] Calling complete() after onFailure()", queue.getName());
		scheduler.complete(queue);
	    }
	}
    }

    //   - the activate(takes) method tests for count of completed requests > 0
    //    - if completed requests > 0, call scheduler.complete()
    //    - if completed request == 0, set active boolean
    //    - if takes is 0 when activate is called, always cal scheduler.complete()
    public void activate(int requests) {
	synchronized(active) {
	    active.set(true);
	    int i = cnt.get();
	    if ((i > 0 || requests == 0) && !signalled) {
		scheduler.complete(queue);
		logger.trace("[{}] Calling complete() on activate(), count is {}", queue.getName(), i);
		signalled = true;
	    }
	}
    }
}
