package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.mq.queue.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author garth
 */
public class RemotingQueueDrain implements Runnable
{
    private static final Logger logger = LoggerFactory.getLogger(RemotingQueueDrain.class);

    public RemotingQueueDrain(Queue queue, LocalToRemoteQueueProcessor processor,
			      int maxConcurrentRequests, FairRemoteQueueTransferScheduler scheduler) {
	this.queue = queue;
	this.processor = processor;
	this.maxConcurrentRequests = maxConcurrentRequests;
	this.scheduler = scheduler;
    }

    private Queue queue;
    private LocalToRemoteQueueProcessor processor;
    private int maxConcurrentRequests;
    private FairRemoteQueueTransferScheduler scheduler;

    @Override
    @SuppressWarnings("unchecked")
    public void run() {
	try {
	    doRun();
	} catch (Exception e) {
	    logger.warn("["+queue.getName()+"] Error running RemotingQueueDrain: ", e);
	}
    }

    private void doRun() {

	int takes = 0;
	int size = (int)queue.getSize();
	int slots = maxConcurrentRequests - processor.getConcurrentRequests();

	//what happens if there are 0 available slots?
	// if there are messages on the queue:
	//  - call scheduler.complete()
	// if there are not messages on the queue:
	//  - we don't have to call scheduler.complete(), as we can rely on queueListener.notEmpty()

	//if there are available slots
	// if the queue size is > 0 
	//  - drain the queue up to available slots
	//  - call completionHandler.activate(takes) passing the number of takes
	//   - the activate(takes) method tests for count of completed requests > 0
	//    - if completed requests > 0, call scheduler.complete()
	//    - if completed request == 0, set active boolean
	//    - if takes is 0 when activate is called, always cal scheduler.complete()
	// if the queue size is == 0
	//  - we don't have to call scheduler.complete(), as we can rely on queueListener.notEmpty()

	logger.trace("[{}] {}/{} slots available, and {} messages in Queue", new Object[] { queue.getName(), slots, maxConcurrentRequests, size });

	if (size > 0) {
	    if (slots == 0) {
		scheduler.complete(queue);
	    } else {
		RemotingCompletionHandler handler = new RemotingCompletionHandler(queue, scheduler);
		for (int i=0;(i<size && i<slots);i++) {
		    processor.run(handler);
		    takes++;
		}
		handler.activate(takes);
	    }
	}

	logger.trace("[{}] Took {} items from Queue.", queue.getName(), takes);
    }

}