package com.cloudhopper.mq.broker;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.mq.message.AttemptCountingMQMessage;
import com.cloudhopper.mq.message.MQMessage;
import com.cloudhopper.mq.queue.Queue;

/**
 * Item to transfer.  This item is not synchronized and its expected that only
 * a single thread at a time would be acting on it.
 * 
 * @author joelauer
 */
public class TransferItem {

    private final Object item;
    // private final byte[] data;
    // private final Class itemType;
    private final AttemptCountingMQMessage message;
    private final Queue localQueue;

    //    public TransferItem(Object item, byte[] data, Class itemType) {
    public TransferItem(Object item, Queue queue) {
        this.item = item;
        // this.data = data;
        this.message = castOrCreateMQMessage();
	this.localQueue = queue;
    }

    /**
     * The local queue this item was taken from
     * @return The queue
     */
    public Queue getLocalQueue() {
	return this.localQueue;
    }

    /**
     * The original item to be transferred as the original Java object.
     * @return The item
     */
    public Object getItem() {
        return this.item;
    }

    /**
     * The transcoded byte array value of the item.
     * @return The item as a byte array
     */
    // public byte[] getData() {
    //     return this.data;
    // }

    /**
     * The underlying class type of the item.
     * @return The item type
     */
    public Class getItemType() {
        return this.localQueue.getElementType();
    }

    public AttemptCountingMQMessage getMessage() {
        return this.message;
    }

    /**
     * Checks if the underlying item implements the MQMessage interface.
     * @return true if the item is an MQMessage
     */
    public boolean isMQMessageImplemented() {
        return (item instanceof MQMessage);
    }

    /**
     * Gets an "MQMessage" for this item.  If the underlying item implements
     * the "MQMessage" interface, it will return it.  If the underlying item
     * doesn't support the "MQMessage" interface, this will return a new default
     * instance.
     * @return An MQMessage
     */
    private AttemptCountingMQMessage castOrCreateMQMessage() {
        if (item instanceof AttemptCountingMQMessage) {
            return (AttemptCountingMQMessage)item;
        } else {
            return new DefaultMQMessage(item);
        }
    }

    private static class DefaultMQMessage<Object> extends AttemptCountingMQMessage {
	public DefaultMQMessage(MQMessage mqMessage) {
	    super();
	    this.body = mqMessage.getBody();
	}

	public DefaultMQMessage(Object item) {
	    super();
	    this.body = item;
	}
    }

    @Override
    public String toString() {
        return new StringBuilder()
            .append("[itemType=")
            .append(getItemType().getCanonicalName())
            // .append(", size=")
            // .append(data.length)
            .append("]")
            .toString();
    }

}
