package com.cloudhopper.mq.broker.protocol;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Thrown when the "TransferAttemptsCounter" value on an MQMessage has been
 * exceeded by the configured policy value.
 * 
 * @author joelauer
 */
public class MaxTransferCountException extends Exception {
    private static final long serialVersionUID = 1L;

    public MaxTransferCountException(String msg) {
        super(msg);
    }

    public MaxTransferCountException(String msg, Throwable t) {
        super(msg, t);
    }
}
