package com.cloudhopper.mq.broker.protocol;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.TreeMap;

/**
 *
 * @author joelauer
 */
public class MonitorResponse extends BaseResponse {

    private int areaId;
    private TreeMap<String,Integer> queues;

    public MonitorResponse() {
        super();
        this.areaId = -1;
        this.queues = new TreeMap<String,Integer>();
    }

    public void setAreaId(int value) {
        this.areaId = value;
    }

    public int getAreaId() {
        return this.areaId;
    }

    public TreeMap<String,Integer> getQueues() {
        return this.queues;
    }

    public void addQueue(String queueName, int weight) {
        this.queues.put(queueName, weight);
    }
    
}
