package com.cloudhopper.mq.broker.protocol;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Constants used in the DistributedQueue protocol.
 * 
 * @author joelauer
 */
public class ProtocolConstants {

    public static final String LINE_DELIMITER = "\n";

    public static final String KEY_VERSION = "ver";
    public static final String KEY_RESULT_CODE = "rc";
    public static final String KEY_MESSAGE = "msg";
    public static final String KEY_QUEUE = "q";
    public static final String KEY_AREA_ID = "area";

    public static final byte VERSION_1_0 = 1;
    public static final byte VERSION_2_0 = 2;
    
    public static final byte CURRENT_VERSION = VERSION_2_0;

    /** Request was ok */
    public static final int RC_OK = 0;
    /** No queue */
    public static final int RC_NO_QUEUE = 1;
    /** No local consumer for queue */
    public static final int RC_NO_CONSUMER = 2;
    /** Unable to parse request */
    public static final int RC_PARSING_FAILED = 3;
    /** Unable to transcode item for queue */
    public static final int RC_TRANSCODING_FAILED = 4;
    /** Group name mismatch */
    public static final int RC_GROUP_NAME_MISMATCH = 5;
    /** Item type mismatch */
    public static final int RC_ITEM_TYPE_MISMATCH = 6;
    /** Unable to put item onto queue */
    public static final int RC_PUT_FAILED = 7;

}
