package com.cloudhopper.mq.broker.protocol;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Utility class for handling protocol responses.
 * 
 * @author joelauer
 */
public class ProtocolResponseUtil {

    /**
     * Verifies a response containing an OK result code.  If it doesn't, this
     * method will throw an exception.
     * @param response The response to verify
     * @throws ProtocolResultCodeException Thrown if the response contains a
     *      result code other than OK (zero).
     */
    static public void verifyResultCodeIsOK(BaseResponse response) throws ProtocolResultCodeException {
        if (response == null) {
            throw new NullPointerException("Response should not be null");
        }

        if (response.getResultCode() != ProtocolConstants.RC_OK) {
            throw new ProtocolResultCodeException(response.getResultCode(), response.getMessage());
        }
    }

}
