package com.cloudhopper.mq.broker.protocol;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Thrown when the remote broker returns a response, but it contains a result
 * code other than zero (OK).  Indicates that the request failed.
 * 
 * @author joelauer
 */
public class ProtocolResultCodeException extends Exception {
    private static final long serialVersionUID = 1L;

    private int resultCode;

    /**
     * Constructs an instance of <code>ProtocolErrorResponseException</code> with the specified detail message.
     * @param resultCode The result code
     * @param message The detail message
     */
    public ProtocolResultCodeException(int resultCode, String message) {
        super("Request to remote broker failed with resultCode [" + resultCode + "] and errorMessage [" + message + "]");
        this.resultCode = resultCode;
    }

    public int getResultCode() {
        return this.resultCode;
    }
}
