package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 *
 * @author joelauer
 */
public class BrokerServerConfiguration {

    private int port;
    private int minThreads;
    private int maxThreads;
    private long keepAliveTimeout;
    private boolean useDirectBuffers;

    public BrokerServerConfiguration() {
        this.port = 7080;
        this.keepAliveTimeout = 30000;
        this.minThreads = 5;
        this.maxThreads = 20;
	this.useDirectBuffers = true;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setKeepAliveTimeout(int value) {
        this.keepAliveTimeout = value;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setMinThreads(int value) {
        this.minThreads = value;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMaxThreads(int value) {
        this.maxThreads = value;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setUseDirectBuffers(boolean value) {
	this.useDirectBuffers = value;
    }

    public boolean getUseDirectBuffers() {
	return this.useDirectBuffers;
    }
}
