package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 *
 * @author joelauer
 */
public interface BrokerServerMBean {

    public boolean isStarted();

    public boolean isStopped();

    void start() throws Exception;

    void stop() throws Exception;

    public int getPort();

    public int getMinThreads();

    public int getMaxThreads();

    /** Troubleshooting requests/responses and why things may be hanging... */
    public long getThreadPoolWaitingTaskCount();
    public long getThreadPoolSubmittedTaskCount();
    public long getThreadPoolCompletedTaskCount();
    public int getThreadPoolIdleThreadCount();
    public int getThreadPoolBusyThreadCount();
    public int getThreadPoolCurrentThreadCount();
    public int getThreadPoolMinThreadCount();
    public int getThreadPoolMaxThreadCount();
    public int getThreadPoolPeakThreadCount();

}
