package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueManager;

/**
 * Interface for intercepting events from a request to a BrokerServer.
 *
 * @author joelauer
 */
public interface BrokerServerPutHandler {

    /**
     * Called to "put" an item onto a Queue for a BrokerServer.
     * If overriding this method, allows any enforcement of custom policies,
     * redirections of items to different queues, etc.
     * @param queueManager The queue manager the BrokerServer is "attached" to
     * @param queue The queue the item was directed to be put on.
     * @param item The item to put on the queue
     * @throws BrokerProtocolException Thrown if there is an exception while
     *      attempting to put the item on the queue.
     */
    public void put(QueueManager queueManager, Queue queue, Object item) throws BrokerProtocolException;

}
