package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.mq.broker.protocol.ProtocolConstants;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueManager;

/**
 * Default implementation for putting items on a queue.
 * 
 * @author joelauer
 */
public class DefaultBrokerServerPutHandler implements BrokerServerPutHandler {

    @SuppressWarnings("unchecked")
    public void put(QueueManager queueManager, Queue queue, Object item) throws BrokerProtocolException {
        try {
            queue.getTemporarySession().put(item);
        } catch (Exception e) {
            throw new BrokerProtocolException(ProtocolConstants.RC_PUT_FAILED, e.getMessage(), e);
        }
    }

}
