package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import javax.servlet.Servlet;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A basic wrapper on Jetty.
 * @author garth
 */
public class JettyHttpServer
{
    private static final Logger logger = LoggerFactory.getLogger(JettyHttpServer.class); 

    public JettyHttpServer() {}

    protected Server jettyServer;
    protected ServletHandler jettyServletHandler;
    protected QueuedThreadPool threadPool;
    protected int port = 7080;
    protected int minThreads = 2;
    protected int maxThreads = 10;
    protected boolean useDirectBuffers = true;

    public int getPort() { return this.port; }
    public void setPort(int port) { this.port = port; }

    public int getMinThreads() { return this.minThreads; }
    public void setMinThreads(int minThreads) { this.minThreads = minThreads; }

    public int getMaxThreads() { return this.maxThreads; }
    public void setMaxThreads(int maxThreads) { this.maxThreads = maxThreads; }

    public boolean getUseDirectBuffers() {return this.useDirectBuffers; }
    public void setUseDirectBuffers(boolean value) {this.useDirectBuffers = value; }

    public QueuedThreadPool getThreadPool() { return this.threadPool; }

    public void addServlet(Servlet s, String name, String path) throws Exception
    {
	ServletHolder holder = new ServletHolder();
	holder.setName(name);
	holder.setServlet(s);

	ServletMapping mapping = new ServletMapping();
	mapping.setServletName(name);
	mapping.setPathSpec(path);

	jettyServletHandler.addServlet(holder);
	jettyServletHandler.addServletMapping(mapping);
    }

    public boolean isRunning()
    {
	return jettyServer.isRunning();
    }

    public void start() throws Exception
    {
	jettyServer = new Server();

	SelectChannelConnector connector = new SelectChannelConnector();
	connector.setPort(port);
	connector.setUseDirectBuffers(useDirectBuffers);
	jettyServer.addConnector(connector);

	threadPool = new QueuedThreadPool();
	threadPool.setMinThreads(minThreads);
	threadPool.setMaxThreads(maxThreads);

	jettyServer.setThreadPool(threadPool);

	HandlerCollection handlerCollection = new HandlerCollection();
 	ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
	// ServletContextHandler context = new ServletContextHandler(contextHandlerCollection, "/", ServletContextHandler.NO_SESSIONS);
	ServletContextHandler context = new ServletContextHandler(contextHandlerCollection, "/", false, false);
	jettyServletHandler = new ServletHandler();
	context.setServletHandler(jettyServletHandler);
	handlerCollection.addHandler(contextHandlerCollection);
	handlerCollection.addHandler(new DefaultHandler());
	handlerCollection.addHandler(new RequestLogHandler());

	jettyServer.setHandler(handlerCollection); 
	jettyServer.setStopAtShutdown(true);
	jettyServer.setSendServerVersion(true);
	
	jettyServer.start();

	if (connector.getUseDirectBuffers()) logger.info("Jetty server is using NIO Direct Buffers");
	else logger.info("Jetty server is NOT using NIO Direct Buffers");
    }

    public void stop() throws Exception
    {
	jettyServer.stop();
    }
    
    public static void main(String[] argv) throws Exception 
    {
	JettyHttpServer server = new JettyHttpServer();
	server.setPort(7080);
	server.setMinThreads(2);
	server.setMaxThreads(10);
	server.start();
	server.addServlet(new NotFound404Servlet(), "Not_Found_Servlet", "/*");
    }
    
}