package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.commons.util.URL;
import com.cloudhopper.mq.broker.DistributedQueueConfiguration;
import com.cloudhopper.mq.queue.QueueManager;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Simple servlet providing a "404" not found error.
 */
public class NotFound404Servlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(NotFound404Servlet.class);

    public NotFound404Servlet() {
        // do nothing
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getWriter().println("The page " + request.getRequestURI() + " not found on this server");
        response.setStatus(HttpServletResponse.SC_NOT_FOUND);
    }
}

    
