package com.cloudhopper.mq.broker.server;

/*
 * #%L
 * ch-mq
 * %%
 * Copyright (C) 2012 Cloudhopper by Twitter
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.cloudhopper.commons.util.LoadBalancedList;
import com.cloudhopper.commons.util.PeriodFormatterUtil;
import com.cloudhopper.mq.Version;
import com.cloudhopper.mq.broker.DistributedQueueManager;
import com.cloudhopper.mq.broker.DistributedQueueState;
import com.cloudhopper.mq.broker.RemoteBrokerInfo;
import com.cloudhopper.mq.broker.RemoteQueueInfo;
import com.cloudhopper.mq.broker.protocol.ProtocolConstants;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.joda.time.DateTime;

/**
 * Servlet for observing MQ broker instance at runtime. Exports useful information
 * and metrics in a structured format.
 */
public class ObserveServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ObserveServlet.class);

    // reference to queue manager
    private final QueueManager queueManager;
    // reference to distributed queue configuration
    private final DistributedQueueManager dqm;

    public ObserveServlet(QueueManager queueManager, DistributedQueueManager dqm) {
        this.queueManager = queueManager;
        this.dqm = dqm;
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	PrintWriter ps = response.getWriter();
        
        response.setContentType("application/json");
                
        // simple way to export via json -- no strings are expected to require escapes (thus no ext library for serialization)
        ps.print("{");
        ps.print("\"libraryVersion\":\"");
        ps.print(Version.getLongVersion());
        ps.print("\"");
        ps.print(",\"protocolVersion\":");
        ps.print(ProtocolConstants.CURRENT_VERSION);
        ps.print(",\"areaId\":");
        ps.print(dqm.getConfiguration().getAreaId());
        ps.print(",\"dataStoreUrl\":");
        ps.print("\"");
        ps.print(queueManager.getConfiguration().getDataStoreUrl());
        ps.print("\"");
        
        ps.print(",\"queueCount\":");
        ps.print(queueManager.getQueueCount());
        
        ps.print(",\"queues\":[");
        
        int i = 0;
        Enumeration<Queue> queues = queueManager.getQueues();
        while (queues.hasMoreElements()) {
            Queue queue = queues.nextElement();
            
            if (i != 0) {
                ps.print(",");
            }
            
            ps.print("{");
            ps.print("\"name\":\"");
            ps.print(queue.getName());
            ps.print("\"");
            ps.print(",");
             ps.print("\"id\":");
            ps.print(queue.getId());
            ps.print(",");
            ps.print("\"size\":");
            ps.print(queue.getSize());
            ps.print(",");
            ps.print("\"putCount\":");
            ps.print(queue.getPutCount());
            ps.print(",");
            ps.print("\"takeCount\":");
            ps.print(queue.getTakeCount());
            ps.print(",");
            ps.print("\"errorCount\":");
            ps.print(queue.getErrorCount());
            ps.print(",");
            ps.print("\"sessionCount\":");
            ps.print(queue.getSessionCount());
            ps.print(",");
            ps.print("\"consumerCount\":");
            ps.print(queue.getConsumerCount());
            ps.print(",");
            ps.print("\"producerCount\":");
            ps.print(queue.getProducerCount());
            ps.print(",");
            ps.print("\"localOnly\":");
            ps.print(queue.isLocalOnly());
            
            ps.print("}");
            
            i++;
        }
        
        ps.print("]");
        
        ps.print("}");

        response.setStatus(HttpServletResponse.SC_OK);
    }
}

    
