/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.commons.util.NamingThreadFactory;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpClientFactory.class);
    private final AsyncHttpClient http;

    public AsyncHttpClientFactory(int requestTimeout, int connectTimeout) {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
        logger.info("Building AsyncHttpClient factory with {}ms requestTimeout and {}ms connectTimeout", (Object)requestTimeout, (Object)connectTimeout);
        AsyncHttpClientConfig.Builder httpConfigBuilder = new AsyncHttpClientConfig.Builder();
        httpConfigBuilder.setRequestTimeoutInMs(requestTimeout);
        httpConfigBuilder.setConnectionTimeoutInMs(connectTimeout);
        ScheduledExecutorService reaper = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new NamingThreadFactory("CHMQ-HttpClient-Reaper", true));
        httpConfigBuilder.setScheduledExecutorService(reaper);
        ExecutorService applicationThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2 + 1, (ThreadFactory)new NamingThreadFactory("CHMQ-HttpClient-Callback", true));
        httpConfigBuilder.setExecutorService(applicationThreadPool);
        httpConfigBuilder.setIOThreadMultiplier(2);
        this.http = new AsyncHttpClient(httpConfigBuilder.build());
    }

    public AsyncHttpClient getClient() {
        return this.http;
    }
}

