/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.DistributedQueueManager;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DistributedQueueEvent
implements Delayed {
    private final long runTime;
    private final String queueName;
    private final DistributedQueueManager.Event event;

    public DistributedQueueEvent(String queueName, DistributedQueueManager.Event event) {
        this(queueName, event, 0L);
    }

    public DistributedQueueEvent(String queueName, DistributedQueueManager.Event event, long msToDelay) {
        this.queueName = queueName;
        this.event = event;
        this.runTime = msToDelay > 0L ? System.currentTimeMillis() + msToDelay : 0L;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public DistributedQueueManager.Event getEvent() {
        return this.event;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        if (this.runTime <= 0L) {
            return 0L;
        }
        long remainingTime = this.runTime - System.currentTimeMillis();
        return unit.convert(remainingTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long otherDelay;
        long myDelay = this.getDelay(TimeUnit.MILLISECONDS);
        if (myDelay < (otherDelay = o.getDelay(TimeUnit.MILLISECONDS))) {
            return -1;
        }
        if (myDelay > otherDelay) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return new StringBuilder(40).append("[queueName=").append(this.queueName).append(", event=").append((Object)this.event).append("]").toString();
    }
}

