/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.DistributedQueueConfiguration;
import com.cloudhopper.mq.broker.DistributedQueueStateListener;
import com.cloudhopper.mq.broker.RemoteBrokerInfo;
import com.cloudhopper.mq.broker.RemoteQueueInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueueState {
    private static final Logger logger = LoggerFactory.getLogger(DistributedQueueState.class);
    private final DistributedQueueConfiguration configuration;
    private final CopyOnWriteArrayList<DistributedQueueStateListener> listeners;
    private final ConcurrentHashMap<String, RemoteBrokerInfo> remoteBrokers;
    private final ConcurrentHashMap<String, RemoteQueueInfo> remoteQueues;

    public DistributedQueueState(DistributedQueueConfiguration configuration) {
        this.configuration = configuration;
        this.listeners = new CopyOnWriteArrayList();
        this.remoteBrokers = new ConcurrentHashMap();
        this.remoteQueues = new ConcurrentHashMap();
    }

    public void clear() {
        for (RemoteBrokerInfo bi : this.remoteBrokers.values()) {
            bi.clear();
        }
        this.remoteBrokers.clear();
        for (RemoteQueueInfo qi : this.remoteQueues.values()) {
            qi.clear();
        }
        this.remoteQueues.clear();
    }

    public void addListener(DistributedQueueStateListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeListener(DistributedQueueStateListener listener) {
        this.listeners.remove(listener);
    }

    public RemoteBrokerInfo getRemoteBroker(String url) {
        return this.remoteBrokers.get(url);
    }

    public ConcurrentHashMap<String, RemoteBrokerInfo> getRemoteBrokers() {
        return this.remoteBrokers;
    }

    public void addRemoteBroker(RemoteBrokerInfo bi) {
        RemoteBrokerInfo oldbi = this.remoteBrokers.putIfAbsent(bi.getUrl(), bi);
        if (oldbi == null) {
            for (DistributedQueueStateListener listener : this.listeners) {
                try {
                    listener.notifyRemoteBrokerAdded(bi);
                }
                catch (Throwable t) {
                    logger.error("Unable to cleanly propagate RemoteBroker @ " + bi.getUrl() + " was added", t);
                }
            }
        }
    }

    public void removeRemoteBroker(String url) {
        RemoteBrokerInfo oldbi = this.remoteBrokers.remove(url);
        if (oldbi != null) {
            for (DistributedQueueStateListener listener : this.listeners) {
                try {
                    listener.notifyRemoteBrokerRemoved(oldbi);
                }
                catch (Throwable t) {
                    logger.error("Unable to cleanly propagate RemoteBroker was removed", t);
                }
            }
        }
    }

    public RemoteQueueInfo getRemoteQueue(String queueName) {
        return this.remoteQueues.get(queueName);
    }

    public ConcurrentHashMap<String, RemoteQueueInfo> getRemoteQueues() {
        return this.remoteQueues;
    }

    public synchronized void updateRemoteBrokerState(String url, int state, String errorMessage, long monitorTime) {
        RemoteBrokerInfo bi = this.getRemoteBroker(url);
        if (bi == null) {
            logger.warn("Unable to update state of RemoteBroker @ [" + url + "] since its not in our master list");
            return;
        }
        boolean changed = bi.setState(state);
        if (state == 1) {
            bi.setLastAvailableTime(monitorTime);
        } else {
            String[] queueNames;
            for (String queueName : queueNames = bi.getRemoteQueues().toArray(new String[0])) {
                this.updateRemoteQueueWeight(queueName, bi.getUrl(), 0);
            }
        }
        bi.setLastErrorMessage(errorMessage);
        if (changed) {
            for (DistributedQueueStateListener listener : this.listeners) {
                try {
                    listener.notifyRemoteBrokerStateChanged(bi, state);
                }
                catch (Throwable t) {
                    logger.error("Unable to cleanly propagate RemoteBroker state change notification", t);
                }
            }
        }
    }

    public synchronized void updateRemoteQueueWeight(String queueName, String url, int weight) {
        block18: {
            RemoteQueueInfo.Event weightEvent;
            RemoteQueueInfo qi;
            block17: {
                RemoteBrokerInfo bi = this.getRemoteBroker(url);
                if (bi == null) {
                    logger.warn("Unable to update weight of RemoteQueue [" + queueName + "] since there is no associated RemoteBroker @ [" + url + "] in our master list");
                    return;
                }
                boolean queueAdded = false;
                qi = this.remoteQueues.get(queueName);
                if (weight <= 0) {
                    if (qi == null) {
                        logger.debug("Unable to update weight of RemoteQueue [" + queueName + "] since it doesn't exist yet AND the weight was zero");
                        return;
                    }
                    bi.removeRemoteQueue(queueName);
                } else {
                    if (qi == null) {
                        logger.debug("RemoteQueue " + queueName + " did not exist, adding it");
                        qi = new RemoteQueueInfo(queueName, this.configuration.getAreaId());
                        RemoteQueueInfo oldqi = this.remoteQueues.putIfAbsent(queueName, qi);
                        if (oldqi == null) {
                            queueAdded = true;
                        } else {
                            qi = oldqi;
                        }
                    }
                    bi.addRemoteQueue(queueName);
                }
                weightEvent = qi.setRemoteBrokerWeight(bi, weight);
                if (queueAdded) {
                    for (DistributedQueueStateListener listener : this.listeners) {
                        try {
                            listener.notifyRemoteQueueAdded(qi);
                        }
                        catch (Throwable t) {
                            logger.error("Unable to cleanly propagate RemoteQueue was added notification", t);
                        }
                    }
                }
                if (weightEvent != RemoteQueueInfo.Event.STATE_CHANGE) break block17;
                for (DistributedQueueStateListener listener : this.listeners) {
                    try {
                        listener.notifyRemoteQueueStateChanged(qi, qi.getState());
                    }
                    catch (Throwable t) {
                        logger.error("Unable to cleanly propagate RemoteQueue state changed notification", t);
                    }
                }
                break block18;
            }
            if (weightEvent != RemoteQueueInfo.Event.ATTRIBUTES_CHANGE) break block18;
            for (DistributedQueueStateListener listener : this.listeners) {
                try {
                    listener.notifyRemoteQueueAttributesChanged(qi);
                }
                catch (Throwable t) {
                    logger.error("Unable to cleanly propagate RemoteQueue attributes changed notification", t);
                }
            }
        }
    }

    public String toDebugString() {
        StringBuilder buf = new StringBuilder(200);
        buf.append("\nDistributedQueueState\n");
        for (RemoteBrokerInfo bi : this.remoteBrokers.values()) {
            buf.append(" RemoteBroker ");
            buf.append(bi.toString());
            buf.append("\n");
            for (String string : bi.getRemoteQueues()) {
                buf.append(" -> RemoteQueue [" + string + "]\n");
            }
        }
        for (RemoteQueueInfo qi : this.remoteQueues.values()) {
            buf.append(" RemoteQueue ");
            buf.append(qi.toString());
            buf.append("\n");
            for (Map.Entry entry : qi.getRemoteBrokers().entrySet()) {
                buf.append(" -> RemoteBroker [" + (String)entry.getKey() + "] [weight=" + ((RemoteQueueInfo.Entry)entry.getValue()).weight.get() + ", sent=" + ((RemoteQueueInfo.Entry)entry.getValue()).sent.get() + "]\n");
            }
        }
        return buf.toString();
    }
}

