/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.AsyncHttpClientFactory;
import com.cloudhopper.mq.broker.AsyncRemoteQueueTransfer;
import com.cloudhopper.mq.broker.CompletionHandler;
import com.cloudhopper.mq.broker.DistributedQueueManager;
import com.cloudhopper.mq.broker.NoMoreRemoteBrokersException;
import com.cloudhopper.mq.broker.RemoteQueueInfo;
import com.cloudhopper.mq.broker.RemoteQueueTransferListener;
import com.cloudhopper.mq.broker.TransferItem;
import com.cloudhopper.mq.broker.TransferResponseHandler;
import com.cloudhopper.mq.broker.protocol.MaxTransferAttemptsCountException;
import com.cloudhopper.mq.broker.protocol.MaxTransferCountException;
import com.cloudhopper.mq.broker.protocol.TransferResponse;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueTemporarySession;
import com.cloudhopper.mq.queue.QueueTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalToRemoteQueueProcessor
implements RemoteQueueTransferListener,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LocalToRemoteQueueProcessor.class);
    private final DistributedQueueManager dqm;
    private final Queue localQueue;
    private final RemoteQueueInfo remoteQueue;
    private final AtomicBoolean killed;
    private final AtomicInteger concurrentRequests;
    private final String name;
    private final AsyncHttpClientFactory httpFactory;

    public LocalToRemoteQueueProcessor(DistributedQueueManager dqm, Queue localQueue, RemoteQueueInfo remoteQueue, AsyncHttpClientFactory httpFactory) {
        this.name = "CHMQ-LocalToRemoteQueueProcessor-" + remoteQueue.getName();
        this.dqm = dqm;
        this.localQueue = localQueue;
        this.remoteQueue = remoteQueue;
        this.killed = new AtomicBoolean(false);
        this.concurrentRequests = new AtomicInteger(0);
        this.httpFactory = httpFactory;
    }

    public Queue getLocalQueue() {
        return this.localQueue;
    }

    public void start() {
        logger.info("[{}] New LocalToRemoteQueueProcessor started for {}", (Object)this.localQueue.getName(), (Object)this.getName());
    }

    public boolean isAlive() {
        return !this.killed.get();
    }

    public String getName() {
        return this.name;
    }

    public int getConcurrentRequests() {
        return this.concurrentRequests.get();
    }

    public void kill() {
        logger.debug("[{}] Processor [{}]: kill() called", (Object)this.localQueue.getName(), (Object)this.getName());
        boolean changed = this.killed.compareAndSet(false, true);
        if (changed) {
            logger.info("[{}] Processor thread [{}]: kill flag set to true and interrupting thread", (Object)this.localQueue.getName(), (Object)this.getName());
        } else {
            logger.warn("[{}] Processor thread [{}]: kill flag already set to true; ignoring kill; no interrupt (duplicate kill request perhaps?)", (Object)this.localQueue.getName(), (Object)this.getName());
        }
    }

    public boolean isKilled() {
        return this.killed.get();
    }

    @Override
    public void notifyRemoteBrokerIsNoLongerAvailable(String remoteBrokerUrl, String errorMessage) {
        this.dqm.getDistributedQueueState().updateRemoteBrokerState(remoteBrokerUrl, 0, errorMessage, System.currentTimeMillis());
    }

    @Override
    public void notifyQueueOnRemoteBrokerIsNoLongerAvailable(String remoteBrokerUrl, String queueName) {
        this.dqm.getDistributedQueueState().updateRemoteQueueWeight(queueName, remoteBrokerUrl, 0);
    }

    @Override
    public void run() {
        try {
            this.run(null);
        }
        catch (Exception e) {
            logger.warn("[" + this.localQueue.getName() + "] Error running LocalToRemoteQueueProcesor: ", (Throwable)e);
        }
    }

    public void run(final CompletionHandler completionHandler) {
        if (!this.killed.get()) {
            if (this.remoteQueue.isNotAvailable()) {
                logger.debug("[{}] Remote queue [{}] no longer available, exiting processor", (Object)this.localQueue.getName(), (Object)this.remoteQueue.getName());
                if (completionHandler != null) {
                    completionHandler.onFailure();
                }
                return;
            }
            Object item = null;
            try {
                QueueTemporarySession take = this.localQueue.getTemporarySession();
                try {
                    item = take.take(this.dqm.getConfiguration().getRemotingTakeTimeout());
                }
                catch (QueueTimeoutException te) {
                    this.dqm.incrementRemotingTakeTimeouts();
                    logger.debug("[{}] Timeout waiting to take from Queue. Size = {}. Item = {}", new Object[]{this.localQueue.getName(), this.localQueue.getSize(), item});
                }
            }
            catch (InterruptedException e) {
                logger.debug("[{}] Processor interrupted while attempting take() from local Queue", (Object)this.localQueue.getName());
                if (completionHandler != null) {
                    completionHandler.onFailure();
                }
                return;
            }
            catch (Exception e) {
                logger.debug("Error taking from queue {}", (Object)this.localQueue);
                logger.error("[" + this.localQueue.getName() + "]Unable to cleanly take() item from local Queue", (Throwable)e);
                if (completionHandler != null) {
                    completionHandler.onFailure();
                }
                return;
            }
            if (item == null) {
                this.dqm.incrementRemotingTakeNulls();
                logger.trace("[{}] Item was null from local Queue", (Object)this.localQueue.getName());
                if (completionHandler != null) {
                    completionHandler.onFailure();
                }
                return;
            }
            final TransferItem transferItem = new TransferItem(item, this.localQueue);
            AsyncRemoteQueueTransfer transfer = new AsyncRemoteQueueTransfer(this.httpFactory.getClient(), this.dqm.getConfiguration(), this, this.remoteQueue, transferItem);
            this.concurrentRequests.incrementAndGet();
            transfer.transfer(new TransferResponseHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onThrowable(Throwable e) {
                    try {
                        if (e instanceof MaxTransferCountException) {
                            logger.error("[" + LocalToRemoteQueueProcessor.this.localQueue.getName() + "]", e);
                        } else if (e instanceof MaxTransferAttemptsCountException) {
                            logger.error("[" + LocalToRemoteQueueProcessor.this.localQueue.getName() + "]", e);
                        } else if (e instanceof NoMoreRemoteBrokersException) {
                            logger.warn("[{}] No more remote brokers for item, going to put it back on the queue (remoteQueue.brokerSize={})", (Object)LocalToRemoteQueueProcessor.this.localQueue.getName(), (Object)LocalToRemoteQueueProcessor.this.remoteQueue.getSize());
                            try {
                                LocalToRemoteQueueProcessor.this.localQueue.getTemporarySession().put(transferItem.getItem());
                            }
                            catch (InterruptedException ex) {
                                logger.error("[{}] Processor interrupted while attempting put() item back onto Queue", (Object)LocalToRemoteQueueProcessor.this.localQueue.getName());
                            }
                            catch (Exception ex) {
                                logger.error("[" + LocalToRemoteQueueProcessor.this.localQueue.getName() + "] Unable to cleanly put() item back onto local Queue", e);
                            }
                        }
                    }
                    finally {
                        LocalToRemoteQueueProcessor.this.concurrentRequests.decrementAndGet();
                        if (completionHandler != null) {
                            completionHandler.onFailure();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(TransferResponse response) {
                    try {
                        logger.trace("[{}] Completed response: {}", (Object)LocalToRemoteQueueProcessor.this.localQueue.getName(), (Object)response);
                    }
                    finally {
                        LocalToRemoteQueueProcessor.this.concurrentRequests.decrementAndGet();
                        if (completionHandler != null) {
                            completionHandler.onSuccess();
                        }
                    }
                }
            });
        }
    }
}

