/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoDupBlockingQueue<E> {
    private static final Logger logger = LoggerFactory.getLogger(NoDupBlockingQueue.class);
    private final Set<E> set = new HashSet();
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final LinkedList<E> list = new LinkedList();
    private int count = 0;

    public NoDupBlockingQueue() {
        this.lock = new ReentrantLock(true);
        this.notEmpty = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            E item = this.list.poll();
            this.set.remove(item);
            --this.count;
            E e = item;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            if (this.set.remove(o)) {
                this.list.remove(o);
                --this.count;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E e) {
        this.lock.lock();
        try {
            if (this.set.add(e)) {
                this.list.offer(e);
                ++this.count;
                this.notEmpty.signal();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                E item = this.list.poll();
                c.add(item);
                this.set.remove(item);
            }
            if (n > 0) {
                this.count = 0;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int setSize = this.set.size();
            int queueSize = this.list.size();
            if (setSize != queueSize) {
                logger.error("{} != {}. THIS SHOULD NEVER HAPPEN.", (Object)setSize, (Object)queueSize);
            }
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

