/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBrokerInfo
implements Comparable<RemoteBrokerInfo> {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBrokerInfo.class);
    public static final int STATE_NOT_AVAILABLE = 0;
    public static final int STATE_AVAILABLE = 1;
    public static final String[] STATES = new String[]{"Not Available", "Available"};
    private final String url;
    private final AtomicInteger id;
    private final AtomicInteger areaId;
    private final AtomicLong lastMonitorTime;
    private final AtomicInteger state;
    private final AtomicLong sent;
    private final AtomicLong lastStateChangedTime;
    private final AtomicLong lastAvailableTime;
    private String lastErrorMessage;
    private byte version;
    private final Set<String> remoteQueues;

    public RemoteBrokerInfo(String url) {
        this.url = url;
        this.id = new AtomicInteger();
        this.areaId = new AtomicInteger();
        this.lastStateChangedTime = new AtomicLong(System.currentTimeMillis());
        this.lastMonitorTime = new AtomicLong(0L);
        this.lastAvailableTime = new AtomicLong(0L);
        this.state = new AtomicInteger(0);
        this.lastErrorMessage = "Not yet monitored";
        this.sent = new AtomicLong(0L);
        this.version = 1;
        this.remoteQueues = Collections.synchronizedSet(new HashSet());
    }

    public void clear() {
        this.remoteQueues.clear();
    }

    public String getUrl() {
        return this.url;
    }

    public Set<String> getRemoteQueues() {
        return this.remoteQueues;
    }

    public boolean addRemoteQueue(String queueName) {
        return this.remoteQueues.add(queueName);
    }

    public boolean removeRemoteQueue(String queueName) {
        return this.remoteQueues.remove(queueName);
    }

    public void clearRemoteQueues() {
        this.remoteQueues.clear();
    }

    public int getId() {
        return this.id.get();
    }

    protected void setId(int value) {
        this.id.set(value);
    }

    public int getAreaId() {
        return this.areaId.get();
    }

    protected void setAreaId(int value) {
        this.areaId.set(value);
    }

    public long getLastMonitorTime() {
        return this.lastMonitorTime.get();
    }

    protected void setLastMonitorTime(long value) {
        this.lastMonitorTime.set(value);
    }

    public long getLastAvailableTime() {
        return this.lastAvailableTime.get();
    }

    protected void setLastAvailableTime(long value) {
        this.lastAvailableTime.set(value);
    }

    public int getState() {
        return this.state.get();
    }

    public void incrementSent(int count) {
        this.sent.addAndGet(count);
    }

    public long getSent() {
        return this.sent.get();
    }

    protected boolean setState(int value) {
        int oldValue = this.state.getAndSet(value);
        if (oldValue != value) {
            this.lastStateChangedTime.set(System.currentTimeMillis());
            logger.info("RemoteBroker @ " + this.url + " changed from " + STATES[oldValue] + " to " + STATES[value]);
            return true;
        }
        return false;
    }

    public long getLastStateChangedTime() {
        return this.lastStateChangedTime.get();
    }

    public void setLastErrorMessage(String value) {
        this.lastErrorMessage = value;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public void setVersion(byte value) {
        this.version = value;
    }

    public byte getVersion() {
        return this.version;
    }

    public boolean isAvailable() {
        return this.state.get() == 1;
    }

    public boolean isNotAvailable() {
        return this.state.get() != 1;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof RemoteBrokerInfo)) {
            return false;
        }
        RemoteBrokerInfo info = (RemoteBrokerInfo)otherObject;
        return this.url.equals(info.url);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(RemoteBrokerInfo o) {
        return this.url.compareTo(o.url);
    }

    public String toString() {
        return new StringBuilder(50).append("[url=").append(this.getUrl()).append(", state=").append(STATES[this.getState()]).append(", areaId=").append(this.getAreaId()).append(", lastMonitorTime=").append(new DateTime(this.getLastMonitorTime())).append("}").toString();
    }
}

