/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.AsyncHttpClientFactory;
import com.cloudhopper.mq.broker.DistributedQueueConfiguration;
import com.cloudhopper.mq.broker.DistributedQueueState;
import com.cloudhopper.mq.broker.RemoteBrokerInfo;
import com.cloudhopper.mq.broker.protocol.MonitorResponse;
import com.cloudhopper.mq.broker.protocol.ProtocolFactory;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBrokerMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBrokerMonitor.class);
    private final DistributedQueueConfiguration configuration;
    private final DistributedQueueState state;
    private final RemoteBrokerInfo remoteBroker;
    private final AsyncHttpClientFactory httpFactory;

    public RemoteBrokerMonitor(DistributedQueueConfiguration configuration, DistributedQueueState state, RemoteBrokerInfo remoteBroker, AsyncHttpClientFactory httpFactory) {
        this.configuration = configuration;
        this.state = state;
        this.remoteBroker = remoteBroker;
        this.httpFactory = httpFactory;
    }

    public RemoteBrokerInfo getRemoteBroker() {
        return this.remoteBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AsyncHttpClient http = this.httpFactory.getClient();
        String cmdurl = this.remoteBroker.getUrl() + "?cmd=monitor";
        if (this.configuration.getGroupName() != null) {
            cmdurl = cmdurl + "&group=" + this.configuration.getGroupName();
        }
        long monitorTime = System.currentTimeMillis();
        try {
            logger.debug("Monitoring RemoteBroker availability @ " + cmdurl);
            this.remoteBroker.setLastMonitorTime(monitorTime);
            Response response = (Response)http.prepareGet(cmdurl).execute().get();
            if (response.getStatusCode() != 200) {
                throw new RuntimeException("Unexpected status code " + response.getStatusCode());
            }
            String body = response.getResponseBody();
            if (body == null) {
                throw new IOException("Response entity was null and a response was expected");
            }
            MonitorResponse monitorResponse = ProtocolFactory.parseMonitorResponse(body);
            this.remoteBroker.setAreaId(monitorResponse.getAreaId());
            this.remoteBroker.setVersion(monitorResponse.getVersion());
            for (Map.Entry<String, Integer> entry : monitorResponse.getQueues().entrySet()) {
                logger.debug("Received update for queueName=" + entry.getKey() + " with weight=" + entry.getValue());
                this.state.updateRemoteQueueWeight(entry.getKey(), this.remoteBroker.getUrl(), entry.getValue());
            }
            this.state.updateRemoteBrokerState(this.remoteBroker.getUrl(), 1, "OK", monitorTime);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            this.state.updateRemoteBrokerState(this.remoteBroker.getUrl(), 0, e.getMessage(), monitorTime);
        }
    }
}

