/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.commons.util.LoadBalancedList;
import com.cloudhopper.commons.util.LoadBalancedLists;
import com.cloudhopper.commons.util.RoundRobinLoadBalancedList;
import com.cloudhopper.mq.broker.RemoteBrokerInfo;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteQueueInfo
implements Comparable<RemoteQueueInfo> {
    private static final Logger logger = LoggerFactory.getLogger(RemoteQueueInfo.class);
    public static final int STATE_NOT_AVAILABLE = 0;
    public static final int STATE_AVAILABLE = 1;
    public static final String[] STATES = new String[]{"Not Available", "Available"};
    private final String name;
    private final int localAreaId;
    private final AtomicInteger state;
    private final ConcurrentHashMap<String, Entry> remoteBrokers;
    private final LoadBalancedList<String> primaryLoadBalancer;
    private final LoadBalancedList<String> failoverLoadBalancer;
    private final AtomicLong lastStateChangedTime;

    public RemoteQueueInfo(String name, int localAreaId) {
        this.name = name;
        this.localAreaId = localAreaId;
        this.state = new AtomicInteger(0);
        this.remoteBrokers = new ConcurrentHashMap();
        this.primaryLoadBalancer = LoadBalancedLists.synchronizedList((LoadBalancedList)new RoundRobinLoadBalancedList());
        this.failoverLoadBalancer = LoadBalancedLists.synchronizedList((LoadBalancedList)new RoundRobinLoadBalancedList());
        this.lastStateChangedTime = new AtomicLong(System.currentTimeMillis());
    }

    public void clear() {
        this.failoverLoadBalancer.clear();
        this.primaryLoadBalancer.clear();
        this.remoteBrokers.clear();
    }

    public String getName() {
        return this.name;
    }

    public int getLocalAreaId() {
        return this.localAreaId;
    }

    public ConcurrentHashMap<String, Entry> getRemoteBrokers() {
        return this.remoteBrokers;
    }

    public int getSize() {
        return this.remoteBrokers.size();
    }

    public int getPrimarySize() {
        return this.primaryLoadBalancer.getSize();
    }

    public List<LoadBalancedList.Node<String>> getPrimaryList() {
        return this.primaryLoadBalancer.getValues();
    }

    public int getFailoverSize() {
        return this.failoverLoadBalancer.getSize();
    }

    public List<LoadBalancedList.Node<String>> getFailoverList() {
        return this.failoverLoadBalancer.getValues();
    }

    public String getNextRemoteBroker() {
        String url = (String)this.primaryLoadBalancer.getNext();
        if (url == null) {
            return (String)this.failoverLoadBalancer.getNext();
        }
        return url;
    }

    public Event setRemoteBrokerWeight(RemoteBrokerInfo bi, int weight) {
        Entry entry = this.remoteBrokers.get(bi.getUrl());
        boolean attributesChanged = false;
        if (entry == null) {
            if (weight <= 0) {
                return Event.NO_CHANGE;
            }
            entry = new Entry(bi);
            Entry oldentry = this.remoteBrokers.putIfAbsent(bi.getUrl(), entry);
            if (oldentry != null) {
                entry = oldentry;
            }
        }
        if (weight <= 0) {
            Entry curEntry = this.remoteBrokers.remove(bi.getUrl());
            if (curEntry != null) {
                attributesChanged = true;
            }
            if (this.localAreaId == bi.getAreaId()) {
                this.primaryLoadBalancer.remove((Object)bi.getUrl());
            } else {
                this.failoverLoadBalancer.remove((Object)bi.getUrl());
            }
        } else {
            int oldWeight = entry.weight.getAndSet(weight);
            if (oldWeight != weight) {
                attributesChanged = true;
            }
            if (this.localAreaId == bi.getAreaId()) {
                this.primaryLoadBalancer.set((Object)bi.getUrl(), weight);
            } else {
                this.failoverLoadBalancer.set((Object)bi.getUrl(), weight);
            }
        }
        int size = this.getSize();
        boolean stateChanged = false;
        stateChanged = size <= 0 ? this.setState(0) : this.setState(1);
        if (stateChanged) {
            return Event.STATE_CHANGE;
        }
        if (attributesChanged) {
            return Event.ATTRIBUTES_CHANGE;
        }
        return Event.NO_CHANGE;
    }

    public int getState() {
        return this.state.get();
    }

    protected boolean setState(int value) {
        int oldValue = this.state.getAndSet(value);
        if (oldValue != value) {
            this.lastStateChangedTime.set(System.currentTimeMillis());
            logger.debug("RemoteQueue " + this.name + " changed state from " + STATES[oldValue] + " to " + STATES[value]);
            return true;
        }
        return false;
    }

    public long getLastStateChangedTime() {
        return this.lastStateChangedTime.get();
    }

    public boolean isAvailable() {
        return this.state.get() == 1;
    }

    public boolean isNotAvailable() {
        return this.state.get() != 1;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof RemoteQueueInfo)) {
            return false;
        }
        RemoteQueueInfo info = (RemoteQueueInfo)otherObject;
        return this.name.equals(info.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(RemoteQueueInfo o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return new StringBuilder(50).append("[name=").append(this.getName()).append(", state=").append(STATES[this.getState()]).append(", brokerSize=").append(this.getSize()).append(", primaryBrokerSize=").append(this.getPrimarySize()).append(", failoverBrokerSize=").append(this.getFailoverSize()).append("]").toString();
    }

    public static enum Event {
        NO_CHANGE,
        STATE_CHANGE,
        ATTRIBUTES_CHANGE;

    }

    public static class Entry {
        public final AtomicInteger weight;
        public final AtomicLong sent;
        public final RemoteBrokerInfo broker;

        public Entry(RemoteBrokerInfo broker) {
            this(broker, 0);
        }

        public Entry(RemoteBrokerInfo broker, int weight) {
            this.broker = broker;
            this.weight = new AtomicInteger(weight);
            this.sent = new AtomicLong();
        }

        public RemoteBrokerInfo getBroker() {
            return this.broker;
        }
    }
}

