/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.LocalToRemoteQueueProcessor;
import com.cloudhopper.mq.broker.RemoteQueueTransferSchedulerMBean;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueListener;
import com.cloudhopper.mq.queue.QueueManager;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteQueueTransferScheduler
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable>,
QueueListener,
RemoteQueueTransferSchedulerMBean {
    private static final Logger logger = LoggerFactory.getLogger(RemoteQueueTransferScheduler.class);
    protected final Map<Queue, LocalToRemoteQueueProcessor> processors;
    protected final AtomicLong scheduledCount;
    protected int maxConcurrentRequests;

    public RemoteQueueTransferScheduler(int maxConcurrentRequests, QueueManager queueManager) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.processors = Collections.synchronizedMap(new HashMap());
        this.scheduledCount = new AtomicLong();
        this.registerMBean(queueManager);
    }

    protected void registerMBean(QueueManager queueManager) {
        if (queueManager.getConfiguration().isJmxEnabled()) {
            try {
                ObjectName name = new ObjectName(queueManager.getConfiguration().getJmxDomain() + ":name=RemoteQueueTransferScheduler");
                queueManager.getConfiguration().getMBeanServer().registerMBean(this, name);
            }
            catch (Exception e) {
                logger.warn("Error while attempting to register DistributedQueueManager as an MBean: {}", (Object)e.toString());
            }
        }
    }

    public void addLocalToRemoteQueueProcessor(Queue queue, LocalToRemoteQueueProcessor processor) {
        logger.debug("[{}] Adding LocalToRemoteQueueProcessor for Queue to scheduler.", (Object)queue.getName());
        this.processors.put(queue, processor);
        queue.setQueueListener((QueueListener)this);
    }

    public void removeLocalToRemoteQueueProcessor(Queue queue) {
        logger.debug("[{}] Removing LocalToRemoteQueueProcessor for Queue from scheduler.", (Object)queue.getName());
        queue.setQueueListener(null);
        this.processors.remove(queue);
    }

    @Override
    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    @Override
    public int getLocalToRemoteQueueProcessorSize() {
        return this.processors.size();
    }

    @Override
    public int getWorkListSize() {
        return this.size();
    }

    @Override
    public long getScheduledCount() {
        return this.scheduledCount.get();
    }

    public abstract void onNotEmpty(Queue var1);

    @Override
    public abstract Runnable take() throws InterruptedException;

    @Override
    public abstract int drainTo(Collection<? super Runnable> var1);

    @Override
    public abstract int size();

    @Override
    public boolean add(Runnable runnable) {
        logger.trace("add(Runnable)");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        logger.trace("contains(Object)");
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        logger.trace("drainTo(Collection, int)");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(Runnable runnable) {
        logger.trace("offer(Runnable)");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(Runnable runnable, long timeout, TimeUnit unit) {
        logger.trace("offer(Runnable, long, TimeUnit)");
        throw new UnsupportedOperationException();
    }

    @Override
    public Runnable peek() {
        logger.trace("peek()");
        throw new UnsupportedOperationException();
    }

    @Override
    public Runnable poll() {
        logger.trace("poll()");
        throw new UnsupportedOperationException();
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) {
        logger.trace("poll(long, TimeUnit)");
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(Runnable runnable) {
        logger.trace("put(Runnable)");
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        logger.trace("remainingCapacity()");
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(Object o) {
        logger.trace("remove(Object)");
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Runnable> iterator() {
        logger.trace("iterator()");
        ArrayList l = new ArrayList();
        this.drainTo(l);
        return l.iterator();
    }
}

