/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.CompletionHandler;
import com.cloudhopper.mq.broker.FairRemoteQueueTransferScheduler;
import com.cloudhopper.mq.queue.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingCompletionHandler
implements CompletionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemotingCompletionHandler.class);
    AtomicBoolean active = new AtomicBoolean(false);
    Queue queue;
    FairRemoteQueueTransferScheduler scheduler;
    AtomicInteger cnt = new AtomicInteger(0);
    boolean signalled = false;

    public RemotingCompletionHandler(Queue queue, FairRemoteQueueTransferScheduler scheduler) {
        this.queue = queue;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess() {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            int i = this.cnt.incrementAndGet();
            if (i == 1 && !this.signalled) {
                this.signalled = true;
                logger.trace("[{}] Calling complete() after onSuccess()", (Object)this.queue.getName());
                this.scheduler.complete(this.queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure() {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            int i = this.cnt.incrementAndGet();
            if (i == 1 && !this.signalled) {
                this.signalled = true;
                logger.trace("[{}] Calling complete() after onFailure()", (Object)this.queue.getName());
                this.scheduler.complete(this.queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(int requests) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            this.active.set(true);
            int i = this.cnt.get();
            if (!(i <= 0 && requests != 0 || this.signalled)) {
                this.scheduler.complete(this.queue);
                logger.trace("[{}] Calling complete() on activate(), count is {}", (Object)this.queue.getName(), (Object)i);
                this.signalled = true;
            }
        }
    }
}

