/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.broker.FairRemoteQueueTransferScheduler;
import com.cloudhopper.mq.broker.LocalToRemoteQueueProcessor;
import com.cloudhopper.mq.broker.RemotingCompletionHandler;
import com.cloudhopper.mq.queue.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingQueueDrain
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RemotingQueueDrain.class);
    private Queue queue;
    private LocalToRemoteQueueProcessor processor;
    private int maxConcurrentRequests;
    private FairRemoteQueueTransferScheduler scheduler;

    public RemotingQueueDrain(Queue queue, LocalToRemoteQueueProcessor processor, int maxConcurrentRequests, FairRemoteQueueTransferScheduler scheduler) {
        this.queue = queue;
        this.processor = processor;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            logger.warn("[" + this.queue.getName() + "] Error running RemotingQueueDrain: ", (Throwable)e);
        }
    }

    private void doRun() {
        int takes = 0;
        int size = (int)this.queue.getSize();
        int slots = this.maxConcurrentRequests - this.processor.getConcurrentRequests();
        logger.trace("[{}] {}/{} slots available, and {} messages in Queue", new Object[]{this.queue.getName(), slots, this.maxConcurrentRequests, size});
        if (size > 0) {
            if (slots == 0) {
                this.scheduler.complete(this.queue);
            } else {
                RemotingCompletionHandler handler = new RemotingCompletionHandler(this.queue, this.scheduler);
                for (int i = 0; i < size && i < slots; ++i) {
                    this.processor.run(handler);
                    ++takes;
                }
                handler.activate(takes);
            }
        }
        logger.trace("[{}] Took {} items from Queue.", (Object)this.queue.getName(), (Object)takes);
    }
}

