/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker;

import com.cloudhopper.mq.message.AttemptCountingMQMessage;
import com.cloudhopper.mq.message.MQMessage;
import com.cloudhopper.mq.queue.Queue;

public class TransferItem {
    private final Object item;
    private final AttemptCountingMQMessage message;
    private final Queue localQueue;

    public TransferItem(Object item, Queue queue) {
        this.item = item;
        this.message = this.castOrCreateMQMessage();
        this.localQueue = queue;
    }

    public Queue getLocalQueue() {
        return this.localQueue;
    }

    public Object getItem() {
        return this.item;
    }

    public Class getItemType() {
        return this.localQueue.getElementType();
    }

    public AttemptCountingMQMessage getMessage() {
        return this.message;
    }

    public boolean isMQMessageImplemented() {
        return this.item instanceof MQMessage;
    }

    private AttemptCountingMQMessage castOrCreateMQMessage() {
        if (this.item instanceof AttemptCountingMQMessage) {
            return (AttemptCountingMQMessage)this.item;
        }
        return new DefaultMQMessage<Object>(this.item);
    }

    public String toString() {
        return "[itemType=" + this.getItemType().getCanonicalName() + "]";
    }

    private static class DefaultMQMessage<Object>
    extends AttemptCountingMQMessage {
        public DefaultMQMessage(MQMessage mqMessage) {
            this.body = mqMessage.getBody();
        }

        public DefaultMQMessage(Object item) {
            this.body = item;
        }
    }
}

