/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker.protocol;

import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.mq.broker.protocol.BaseResponse;
import com.cloudhopper.mq.broker.protocol.MonitorResponse;
import com.cloudhopper.mq.broker.protocol.ProtocolParsingException;
import com.cloudhopper.mq.broker.protocol.TransferResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolFactory.class);

    public static String[] splitBody(String body) throws ProtocolParsingException {
        if (StringUtil.isEmpty((String)body)) {
            throw new ProtocolParsingException("Unable to split body into lines as body was empty");
        }
        return body.split("\n");
    }

    public static String[] splitKeyValue(String line) throws ProtocolParsingException {
        int pos = line.indexOf(58);
        if (pos <= 0) {
            throw new ProtocolParsingException("Unable to split line [" + line + "] into a key and value");
        }
        String[] kv = new String[2];
        kv[0] = line.substring(0, pos);
        if (pos + 1 >= line.length()) {
            throw new ProtocolParsingException("The line [" + line + "] resulted in an empty value");
        }
        kv[1] = line.substring(pos + 1);
        return kv;
    }

    public static byte parseVersionValue(String value) throws ProtocolParsingException {
        try {
            return Byte.parseByte(value);
        }
        catch (Exception e) {
            throw new ProtocolParsingException("Unable to parse [" + value + "] into version byte", e);
        }
    }

    public static int parseResultCodeValue(String value) throws ProtocolParsingException {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ProtocolParsingException("Unable to parse [" + value + "] into resultCode integer", e);
        }
    }

    public static int parseAreaIdValue(String value) throws ProtocolParsingException {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ProtocolParsingException("Unable to parse [" + value + "] into areaId integer", e);
        }
    }

    public static void processQueueValue(String value, MonitorResponse response) throws ProtocolParsingException {
        String[] v = value.split(",");
        if (v.length != 2) {
            throw new ProtocolParsingException("Unable to parse [" + value + "] into a queue name and weight - not 2 tokens");
        }
        int weight = 0;
        try {
            weight = Integer.parseInt(v[1]);
        }
        catch (Exception e) {
            throw new ProtocolParsingException("Unable to parse [" + v[1] + "] into a queue weight integer", e);
        }
        response.addQueue(v[0], weight);
    }

    public static boolean handleBaseResponseKeys(BaseResponse response, String key, String value) throws ProtocolParsingException {
        if (key.equals("rc")) {
            response.setResultCode(ProtocolFactory.parseResultCodeValue(value));
            return true;
        }
        if (key.equals("msg")) {
            response.setMessage(value);
            return true;
        }
        if (key.equals("ver")) {
            response.setVersion(ProtocolFactory.parseVersionValue(value));
            return true;
        }
        return false;
    }

    public static MonitorResponse parseMonitorResponse(String body) throws ProtocolParsingException {
        MonitorResponse response = new MonitorResponse();
        String[] lines = ProtocolFactory.splitBody(body);
        for (int i = 0; i < lines.length; ++i) {
            String value;
            String[] kv = ProtocolFactory.splitKeyValue(lines[i]);
            String key = kv[0];
            if (ProtocolFactory.handleBaseResponseKeys(response, key, value = kv[1])) continue;
            if (key.equals("area")) {
                response.setAreaId(ProtocolFactory.parseAreaIdValue(value));
                continue;
            }
            if (key.equals("q")) {
                ProtocolFactory.processQueueValue(value, response);
                continue;
            }
            logger.warn("Unsupported key [" + key + "] in monitor response line [" + lines[i] + "]");
        }
        if (response.getResultCode() < 0) {
            throw new ProtocolParsingException("Monitor response did not contain a valid resultCode");
        }
        return response;
    }

    public static TransferResponse parseTransferResponse(String body) throws ProtocolParsingException {
        TransferResponse response = new TransferResponse();
        String[] lines = ProtocolFactory.splitBody(body);
        for (int i = 0; i < lines.length; ++i) {
            String value;
            String[] kv = ProtocolFactory.splitKeyValue(lines[i]);
            String key = kv[0];
            if (ProtocolFactory.handleBaseResponseKeys(response, key, value = kv[1])) continue;
            logger.warn("Unsupported key [" + key + "] in transfer response line [" + lines[i] + "]");
        }
        if (response.getResultCode() < 0) {
            throw new ProtocolParsingException("Transfer response did not contain a valid resultCode");
        }
        return response;
    }
}

