/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker.server;

import com.cloudhopper.mq.broker.DistributedQueueManager;
import com.cloudhopper.mq.broker.server.BrokerServerConfiguration;
import com.cloudhopper.mq.broker.server.BrokerServerMBean;
import com.cloudhopper.mq.broker.server.BrokerServerPutHandler;
import com.cloudhopper.mq.broker.server.BrokerServlet;
import com.cloudhopper.mq.broker.server.JettyHttpServer;
import com.cloudhopper.mq.broker.server.NotFound404Servlet;
import com.cloudhopper.mq.broker.server.ObserveServlet;
import com.cloudhopper.mq.broker.server.StatusServlet;
import com.cloudhopper.mq.queue.QueueManager;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerServer
implements BrokerServerMBean {
    private static final Logger logger = LoggerFactory.getLogger(BrokerServer.class);
    private final BrokerServerConfiguration configuration;
    private final BrokerServlet brokerServlet;
    private final StatusServlet statusServlet;
    private final ObserveServlet observeServlet;
    private final QueueManager queueManager;
    private final DistributedQueueManager dqm;
    private JettyHttpServer jetty;

    public BrokerServer(BrokerServerConfiguration configuration, QueueManager queueManager, DistributedQueueManager dqm) {
        this.configuration = configuration;
        this.queueManager = queueManager;
        this.dqm = dqm;
        this.brokerServlet = new BrokerServlet(queueManager, dqm);
        this.statusServlet = new StatusServlet(queueManager, dqm);
        this.observeServlet = new ObserveServlet(queueManager, dqm);
        this.registerMBean();
    }

    protected void registerMBean() {
        if (this.queueManager.getConfiguration().isJmxEnabled()) {
            try {
                ObjectName name = new ObjectName(this.queueManager.getConfiguration().getJmxDomain() + ":name=BrokerServer");
                this.queueManager.getConfiguration().getMBeanServer().registerMBean(this, name);
            }
            catch (Exception e) {
                logger.warn("Error while attempting to register BrokerServer as an MBean: {}", (Object)e.toString());
            }
        }
    }

    public void setPutHandler(BrokerServerPutHandler putHandler) {
        this.brokerServlet.setPutHandler(putHandler);
    }

    public BrokerServerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getPort() {
        return this.configuration.getPort();
    }

    @Override
    public int getMinThreads() {
        return this.configuration.getMinThreads();
    }

    @Override
    public int getMaxThreads() {
        return this.configuration.getMaxThreads();
    }

    public boolean getUseDirectBuffers() {
        return this.configuration.getUseDirectBuffers();
    }

    @Override
    public boolean isStarted() {
        return this.jetty != null && this.jetty.isRunning();
    }

    @Override
    public boolean isStopped() {
        return this.jetty == null || !this.jetty.isRunning();
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            logger.warn("Ignoring start request, already started");
            return;
        }
        this.jetty = new JettyHttpServer();
        this.jetty.setPort(this.getPort());
        this.jetty.setMinThreads(this.getMinThreads());
        this.jetty.setMaxThreads(this.getMaxThreads());
        this.jetty.setUseDirectBuffers(this.getUseDirectBuffers());
        this.jetty.start();
        this.jetty.addServlet((Servlet)new NotFound404Servlet(), "Not_Found_Servlet", "/*");
        this.jetty.addServlet((Servlet)this.statusServlet, "Status_Servlet", "/status");
        this.jetty.addServlet((Servlet)this.brokerServlet, "Broker_Servlet", "/broker");
        this.jetty.addServlet((Servlet)this.observeServlet, "Observe_Servlet", "/observe");
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.isStarted()) {
            logger.warn("Ignoring stop request, already stopped");
            return;
        }
        logger.info("Attempting to stop broker HTTP server...");
        this.jetty.stop();
    }

    @Override
    public long getThreadPoolWaitingTaskCount() {
        return -1L;
    }

    @Override
    public long getThreadPoolSubmittedTaskCount() {
        return -1L;
    }

    @Override
    public long getThreadPoolCompletedTaskCount() {
        return -1L;
    }

    @Override
    public int getThreadPoolBusyThreadCount() {
        return -1;
    }

    @Override
    public int getThreadPoolIdleThreadCount() {
        return this.jetty.getThreadPool().getIdleThreads();
    }

    @Override
    public int getThreadPoolCurrentThreadCount() {
        return this.jetty.getThreadPool().getThreads();
    }

    @Override
    public int getThreadPoolMinThreadCount() {
        return this.jetty.getThreadPool().getMinThreads();
    }

    @Override
    public int getThreadPoolMaxThreadCount() {
        return this.jetty.getThreadPool().getMaxThreads();
    }

    @Override
    public int getThreadPoolPeakThreadCount() {
        return -1;
    }
}

