/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker.server;

import com.cloudhopper.commons.util.StringUtil;
import com.cloudhopper.mq.broker.DistributedQueueManager;
import com.cloudhopper.mq.broker.server.BrokerProtocolException;
import com.cloudhopper.mq.broker.server.BrokerServerPutHandler;
import com.cloudhopper.mq.broker.server.DefaultBrokerServerPutHandler;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueManager;
import com.cloudhopper.mq.transcoder.Transcoder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(BrokerServlet.class);
    private final QueueManager queueManager;
    private final DistributedQueueManager dqm;
    private BrokerServerPutHandler putHandler;

    public BrokerServlet(QueueManager queueManager, DistributedQueueManager dqm) {
        this.queueManager = queueManager;
        this.dqm = dqm;
        this.putHandler = new DefaultBrokerServerPutHandler();
    }

    public void setPutHandler(BrokerServerPutHandler putHandler) {
        this.putHandler = putHandler;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block26: {
            try {
                PrintWriter ps = response.getWriter();
                if (request.getQueryString() == null) {
                    response.setStatus(400);
                    ps.print("A query property must exist");
                    return;
                }
                String group = request.getParameter("group");
                if (!StringUtil.isEmpty((String)group) && !group.equalsIgnoreCase(this.dqm.getConfiguration().getGroupName())) {
                    response.setStatus(400);
                    ps.print("The group '" + group + "' in your request does not match the group '" + this.dqm.getConfiguration().getGroupName() + "' configured for this server");
                    return;
                }
                String cmd = request.getParameter("cmd");
                if (StringUtil.isEmpty((String)cmd)) {
                    response.setStatus(400);
                    ps.print("The cmd query parameter must exist");
                    return;
                }
                if (cmd.equals("queues")) {
                    ps.println("<table cellspacing=0 cellpadding=1 border=1>");
                    ps.println("<tr><td>Queue Name</td><td>Size</td><td>Producers</td><td>Consumers</td><td>Last Producer Date</td><td>Last Consumer Date</td></tr>");
                    Enumeration queues = this.queueManager.getQueues();
                    while (queues.hasMoreElements()) {
                        Queue queue = (Queue)queues.nextElement();
                        ps.print("<tr><td>");
                        ps.print(queue.getName());
                        ps.print("</td><td>");
                        ps.print(queue.getSize());
                        ps.print("</td><td>");
                        ps.print(queue.getProducerCount());
                        ps.print("</td><td>");
                        ps.print(queue.getConsumerCount());
                        ps.print("</td><td>");
                        ps.print(queue.getLastProducerCountChangeTime());
                        ps.print("</td><td>");
                        ps.print(queue.getLastConsumerCountChangeTime());
                        ps.print("</td></tr>");
                    }
                    ps.println("</table>");
                    break block26;
                }
                if (cmd.equals("monitor")) {
                    long since = -1L;
                    String sinceString = request.getParameter("since");
                    if (!StringUtil.isEmpty((String)sinceString)) {
                        try {
                            since = Long.parseLong(sinceString);
                        }
                        catch (Exception e) {
                            response.setStatus(400);
                            ps.print("Unable to convert since query parameter to a long value");
                            return;
                        }
                    }
                    ps.print("rc:0\n");
                    ps.print("ver:2\n");
                    ps.print("area:" + this.dqm.getConfiguration().getAreaId() + "\n");
                    Enumeration queues = this.queueManager.getQueues();
                    while (queues.hasMoreElements()) {
                        Queue queue = (Queue)queues.nextElement();
                        if (since > 0L && queue.getLastConsumerCountChangeTime() < since || queue.isLocalOnly()) continue;
                        ps.print("q");
                        ps.print(":");
                        ps.print(queue.getName());
                        ps.print(",");
                        ps.print(queue.getConsumerCount());
                        ps.print("\n");
                    }
                    break block26;
                }
                if (cmd.equals("transfer")) {
                    String queueName = request.getParameter("queue");
                    if (StringUtil.isEmpty((String)queueName)) {
                        response.setStatus(400);
                        ps.print("Parameter queue is required for a transfer request");
                        return;
                    }
                    byte[] entityContent = BrokerServlet.requestToByteArray(request);
                    if (entityContent == null || entityContent.length <= 0) {
                        response.setStatus(400);
                        ps.print("Probably not a POST request since body does not contain an entity");
                        return;
                    }
                    logger.trace("[{}] Received transfer request to queue with an item having a byteLength [{}]", (Object)queueName, (Object)entityContent.length);
                    int result = 0;
                    String message = "OK";
                    if (!this.queueManager.hasQueue(queueName)) {
                        result = 1;
                        message = "The queue " + queueName + " was not found";
                    } else {
                        Queue queue = this.queueManager.getQueue(queueName);
                        if (queue.getConsumerCount() <= 0) {
                            result = 2;
                            message = "No local consumers for queue " + queueName;
                        } else {
                            Transcoder tc = queue.getTranscoder();
                            try {
                                Object item = tc.decode(entityContent);
                                logger.trace("[{}] Parsed item: {}", (Object)queueName, item);
                                try {
                                    this.putHandler.put(this.queueManager, queue, item);
                                }
                                catch (BrokerProtocolException e) {
                                    logger.error("", (Throwable)e);
                                    result = e.getErrorCode();
                                    message = e.getMessage();
                                }
                            }
                            catch (Throwable t) {
                                logger.error("", t);
                                result = 4;
                                message = "Unable to transcode byte array into an item";
                            }
                        }
                    }
                    if (result == 0) {
                        logger.trace("[{}] Item transfer successful", (Object)queueName);
                    } else {
                        logger.error("[{}] Item transfer failed to Queue with result [{}] message [{}]", new Object[]{queueName, result, message});
                    }
                    ps.print("rc:" + result + "\n");
                    ps.print("msg:" + message + "\n");
                    break block26;
                }
                response.setStatus(400);
                ps.print("Unable to process cmd '" + cmd + "'");
                return;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] requestToByteArray(HttpServletRequest request) throws IOException {
        int len = request.getContentLength();
        if (len <= 0) {
            throw new IllegalArgumentException("Zero or unknown body length");
        }
        ServletInputStream is = request.getInputStream();
        if (is == null) {
            return null;
        }
        try {
            byte[] b = new byte[len];
            is.read(b);
            byte[] byArray = b;
            return byArray;
        }
        finally {
            is.close();
        }
    }
}

