/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker.server;

import com.cloudhopper.mq.broker.server.NotFound404Servlet;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyHttpServer.class);
    protected Server jettyServer;
    protected ServletHandler jettyServletHandler;
    protected QueuedThreadPool threadPool;
    protected int port = 7080;
    protected int minThreads = 2;
    protected int maxThreads = 10;
    protected boolean useDirectBuffers = true;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public boolean getUseDirectBuffers() {
        return this.useDirectBuffers;
    }

    public void setUseDirectBuffers(boolean value) {
        this.useDirectBuffers = value;
    }

    public QueuedThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void addServlet(Servlet s, String name, String path) throws Exception {
        ServletHolder holder = new ServletHolder();
        holder.setName(name);
        holder.setServlet(s);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(name);
        mapping.setPathSpec(path);
        this.jettyServletHandler.addServlet(holder);
        this.jettyServletHandler.addServletMapping(mapping);
    }

    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    public void start() throws Exception {
        this.jettyServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setUseDirectBuffers(this.useDirectBuffers);
        this.jettyServer.addConnector((Connector)connector);
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setMinThreads(this.minThreads);
        this.threadPool.setMaxThreads(this.maxThreads);
        this.jettyServer.setThreadPool((ThreadPool)this.threadPool);
        HandlerCollection handlerCollection = new HandlerCollection();
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)contextHandlerCollection, "/", false, false);
        this.jettyServletHandler = new ServletHandler();
        context.setServletHandler(this.jettyServletHandler);
        handlerCollection.addHandler((Handler)contextHandlerCollection);
        handlerCollection.addHandler((Handler)new DefaultHandler());
        handlerCollection.addHandler((Handler)new RequestLogHandler());
        this.jettyServer.setHandler((Handler)handlerCollection);
        this.jettyServer.setStopAtShutdown(true);
        this.jettyServer.setSendServerVersion(true);
        this.jettyServer.start();
        if (connector.getUseDirectBuffers()) {
            logger.info("Jetty server is using NIO Direct Buffers");
        } else {
            logger.info("Jetty server is NOT using NIO Direct Buffers");
        }
    }

    public void stop() throws Exception {
        this.jettyServer.stop();
    }

    public static void main(String[] argv) throws Exception {
        JettyHttpServer server = new JettyHttpServer();
        server.setPort(7080);
        server.setMinThreads(2);
        server.setMaxThreads(10);
        server.start();
        server.addServlet((Servlet)new NotFound404Servlet(), "Not_Found_Servlet", "/*");
    }
}

