/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker.server;

import com.cloudhopper.mq.Version;
import com.cloudhopper.mq.broker.DistributedQueueManager;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ObserveServlet.class);
    private final QueueManager queueManager;
    private final DistributedQueueManager dqm;

    public ObserveServlet(QueueManager queueManager, DistributedQueueManager dqm) {
        this.queueManager = queueManager;
        this.dqm = dqm;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter ps = response.getWriter();
        response.setContentType("application/json");
        ps.print("{");
        ps.print("\"libraryVersion\":\"");
        ps.print(Version.getLongVersion());
        ps.print("\"");
        ps.print(",\"protocolVersion\":");
        ps.print(2);
        ps.print(",\"areaId\":");
        ps.print(this.dqm.getConfiguration().getAreaId());
        ps.print(",\"dataStoreUrl\":");
        ps.print("\"");
        ps.print(this.queueManager.getConfiguration().getDataStoreUrl());
        ps.print("\"");
        ps.print(",\"queueCount\":");
        ps.print(this.queueManager.getQueueCount());
        ps.print(",\"queues\":[");
        int i = 0;
        Enumeration queues = this.queueManager.getQueues();
        while (queues.hasMoreElements()) {
            Queue queue = (Queue)queues.nextElement();
            if (i != 0) {
                ps.print(",");
            }
            ps.print("{");
            ps.print("\"name\":\"");
            ps.print(queue.getName());
            ps.print("\"");
            ps.print(",");
            ps.print("\"id\":");
            ps.print(queue.getId());
            ps.print(",");
            ps.print("\"size\":");
            ps.print(queue.getSize());
            ps.print(",");
            ps.print("\"putCount\":");
            ps.print(queue.getPutCount());
            ps.print(",");
            ps.print("\"takeCount\":");
            ps.print(queue.getTakeCount());
            ps.print(",");
            ps.print("\"errorCount\":");
            ps.print(queue.getErrorCount());
            ps.print(",");
            ps.print("\"sessionCount\":");
            ps.print(queue.getSessionCount());
            ps.print(",");
            ps.print("\"consumerCount\":");
            ps.print(queue.getConsumerCount());
            ps.print(",");
            ps.print("\"producerCount\":");
            ps.print(queue.getProducerCount());
            ps.print(",");
            ps.print("\"localOnly\":");
            ps.print(queue.isLocalOnly());
            ps.print("}");
            ++i;
        }
        ps.print("]");
        ps.print("}");
        response.setStatus(200);
    }
}

