/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.mq.broker.server;

import com.cloudhopper.commons.util.LoadBalancedList;
import com.cloudhopper.commons.util.PeriodFormatterUtil;
import com.cloudhopper.mq.broker.DistributedQueueManager;
import com.cloudhopper.mq.broker.DistributedQueueState;
import com.cloudhopper.mq.broker.RemoteBrokerInfo;
import com.cloudhopper.mq.broker.RemoteQueueInfo;
import com.cloudhopper.mq.queue.Queue;
import com.cloudhopper.mq.queue.QueueManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(StatusServlet.class);
    private final QueueManager queueManager;
    private final DistributedQueueManager dqm;

    public StatusServlet(QueueManager queueManager, DistributedQueueManager dqm) {
        this.queueManager = queueManager;
        this.dqm = dqm;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter ps = response.getWriter();
        ps.println("<html>");
        ps.println(" <head>");
        ps.println("  <title>Queue Status</title>");
        ps.println("  <style type=\"text/css\">");
        ps.println("   h1, p, table, a, body { font-family: Helvetica,Verdana,Arial; font-size: 11px; }");
        ps.println("   h1 { font-size: 13px; font-weight: bold; }");
        ps.println("   table { border: solid 1px #999999; border-collapse:collapse; empty-cells: show; padding:2px; }");
        ps.println("   th { font-weight: bold; background-color:#666666; color:#FFFFFF; text-align: left; }");
        ps.println("   th, td  { border-collapse:collapse; border: solid 1px #999999; }");
        ps.println("   tr.queue  { background-color:#F5F5F5; }");
        ps.println("  </style>");
        ps.println(" </head>");
        ps.println(" <body>");
        ps.println("<h1>Services</h1>");
        ps.println("<table>");
        ps.println("<tr><th>Service</th><th>Status</th></tr>");
        ps.println("<tr><td>QueueManager</td><td>" + (this.queueManager.isStarted() ? "Started" : "Stopped") + "</td></tr>");
        ps.println("<tr><td>DistributedQueueManager</td><td>" + (this.dqm.isStarted() ? "Started" : "Stopped") + "</td></tr>");
        ps.println("</table>");
        ps.println("<h1>Queues</h1>");
        ps.println("<table>");
        ps.println("<tr><th>Queue Name</th><th>Size</th><th>Puts</th><th>Takes</th><th>Errors</th><th>Sessions</th><th>Consumers</th><th>Producers</th><th>Remote Processor?</th><th>Item Type</th></tr>");
        if (this.queueManager.getQueueCount() <= 0) {
            ps.println("<tr><td colspan=9>None</td></tr>");
        } else {
            TreeMap<String, Queue> sortedQueues = new TreeMap<String, Queue>();
            Enumeration queues = this.queueManager.getQueues();
            while (queues.hasMoreElements()) {
                Queue queue = (Queue)queues.nextElement();
                sortedQueues.put(queue.getName(), queue);
            }
            for (Queue queue : sortedQueues.values()) {
                ps.print("<tr><td>");
                ps.print(queue.getName());
                ps.print("</td><td align=right>");
                ps.print(queue.getSize());
                ps.print("</td><td align=right>");
                ps.print(queue.getPutCount());
                ps.print("</td><td align=right>");
                ps.print(queue.getTakeCount());
                ps.print("</td><td align=right>");
                ps.print(queue.getErrorCount());
                ps.print("</td><td align=right>");
                ps.print(queue.getSessionCount());
                ps.print("</td><td align=right>");
                ps.print(queue.getConsumerCount());
                ps.print("</td><td align=right>");
                ps.print(queue.getProducerCount());
                ps.print("</td><td align=center>");
                ps.print(this.dqm.getQueueProcessors().containsKey(queue.getName()));
                ps.print("</td><td>");
                ps.print(queue.getElementType().getCanonicalName());
                ps.print("</td></tr>");
            }
        }
        ps.println("</table>");
        DistributedQueueState dqs = this.dqm.getDistributedQueueState();
        ps.println("<h1>Distributed Queue State - Viewed By Remote Broker</h1>");
        ps.println("<table>");
        ps.println("<tr><th>Remote Broker</th><th>Area</th><th>State</th><th>State Time</th><th>Last Available Date</th><th>Last Error Message</th></tr>");
        TreeMap<String, RemoteBrokerInfo> sortedRemoteBrokers = new TreeMap<String, RemoteBrokerInfo>();
        for (RemoteBrokerInfo bi : dqs.getRemoteBrokers().values()) {
            sortedRemoteBrokers.put(bi.getUrl(), bi);
        }
        for (RemoteBrokerInfo bi : sortedRemoteBrokers.values()) {
            ps.print("<tr><td>");
            ps.print(bi.getUrl());
            ps.print("</td><td>");
            ps.print(bi.getAreaId());
            ps.print("</td><td>");
            ps.print(RemoteBrokerInfo.STATES[bi.getState()]);
            ps.print("</td><td>");
            long stateDuration = System.currentTimeMillis() - bi.getLastStateChangedTime();
            ps.print(PeriodFormatterUtil.toLinuxUptimeStyleString((long)stateDuration));
            ps.print("</td><td>");
            ps.print((Object)(bi.getLastAvailableTime() <= 0L ? "Never" : new DateTime(bi.getLastAvailableTime())));
            ps.print("</td><td>");
            ps.print(bi.getLastErrorMessage() == null ? "" : bi.getLastErrorMessage());
            ps.print("</td></tr>");
            if (bi.getRemoteQueues().size() <= 0) continue;
            ps.print("<tr class=\"queue\"><td colspan=6>");
            ps.print("&nbsp;>&nbsp; Remote Queues: ");
            TreeSet<String> sortedRemoteQueues = new TreeSet<String>();
            for (String q : bi.getRemoteQueues()) {
                sortedRemoteQueues.add(q);
            }
            int i = 0;
            for (String q : sortedRemoteQueues) {
                if (i != 0) {
                    ps.print(", ");
                }
                ps.print(q);
                ++i;
            }
            ps.print("</td></tr>");
        }
        ps.println("</table>");
        ps.println("<h1>Distributed Queue State - Viewed By Remote Queue</h1>");
        ps.println("<table>");
        ps.println("<tr><th>Queue Name</th><th>State</th><th>State Time</th><th>Remote Brokers</th></tr>");
        if (dqs.getRemoteQueues().size() <= 0) {
            ps.println("<tr><td colspan=3>None</td></tr>");
        } else {
            TreeMap<String, RemoteQueueInfo> sortedRemoteQueues = new TreeMap<String, RemoteQueueInfo>();
            for (RemoteQueueInfo qi : dqs.getRemoteQueues().values()) {
                sortedRemoteQueues.put(qi.getName(), qi);
            }
            for (RemoteQueueInfo qi : sortedRemoteQueues.values()) {
                ps.print("<tr><td>");
                ps.print(qi.getName());
                ps.print("</td><td>");
                ps.print(RemoteQueueInfo.STATES[qi.getState()]);
                ps.print("</td><td>");
                long stateDuration = System.currentTimeMillis() - qi.getLastStateChangedTime();
                ps.print(PeriodFormatterUtil.toLinuxUptimeStyleString((long)stateDuration));
                ps.print("</td><td>");
                ps.print("all: ");
                ps.print(qi.getSize());
                ps.print(" [primary: ");
                ps.print(qi.getPrimarySize());
                ps.print(", failover: ");
                ps.print(qi.getFailoverSize());
                ps.print("]");
                ps.print("</td></tr>");
                for (LoadBalancedList.Node<String> entry : qi.getPrimaryList()) {
                    ps.print("<tr class=\"queue\"><td colspan=4>");
                    ps.print("&nbsp;>&nbsp; Primary Broker: " + (String)entry.getValue() + " [weight: " + entry.getWeight() + "]");
                    ps.print("</td></tr>");
                }
                for (LoadBalancedList.Node<String> entry : qi.getFailoverList()) {
                    ps.print("<tr class=\"queue\"><td colspan=4>");
                    ps.print("&nbsp;>&nbsp; Failover Broker: " + (String)entry.getValue() + " [weight: " + entry.getWeight() + "]");
                    ps.print("</td></tr>");
                }
            }
        }
        ps.println("</table>");
        ps.println(" </body>");
        ps.println("</html>");
        response.setStatus(200);
    }
}

