/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.content.Context;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import com.cloudinary.android.BackgroundRequestStrategy;
import com.cloudinary.android.Logger;
import com.cloudinary.android.MediaManager;
import com.cloudinary.android.RequestParams;
import com.cloudinary.android.UploadRequest;
import com.cloudinary.android.callback.UploadStatus;
import com.cloudinary.android.policy.UploadPolicy;
import com.evernote.android.job.Job;
import com.evernote.android.job.JobManager;
import com.evernote.android.job.JobRequest;
import com.evernote.android.job.util.support.PersistableBundleCompat;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AndroidJobStrategy
implements BackgroundRequestStrategy {
    private static final String JOB_TAG = "CLD";
    private static final String TAG = AndroidJobStrategy.class.getSimpleName();
    private static final Map<String, WeakReference<Thread>> threads = new ConcurrentHashMap<String, WeakReference<Thread>>();
    private static final Object threadsMapLockObject = new Object();
    private static final int RUN_NOW_TIME_WINDOW_START = 10000;
    private static final int RUN_NOW_TIME_WINDOW_END = 60000;

    AndroidJobStrategy() {
    }

    static JobRequest adapt(UploadRequest request) {
        PersistableBundleCompat extras = new PersistableBundleCompat();
        request.populateParamsFromFields(new AndroidJobRequestParams(extras));
        UploadPolicy policy = request.getUploadPolicy();
        JobRequest.Builder builder = new JobRequest.Builder(JOB_TAG).setBackoffCriteria(policy.getBackoffMillis(), AndroidJobStrategy.adaptPolicy(policy.getBackoffPolicy())).setExtras(extras).setExecutionWindow(request.getTimeWindow().getMinLatencyOffsetMillis(), request.getTimeWindow().getMaxExecutionDelayMillis()).setRequiredNetworkType(AndroidJobStrategy.adaptNetworkType(policy.getNetworkType())).setRequiresCharging(policy.isRequiresCharging()).setRequiresDeviceIdle(policy.isRequiresIdle()).setRequirementsEnforced(true);
        return builder.build();
    }

    private static JobRequest.BackoffPolicy adaptPolicy(UploadPolicy.BackoffPolicy backoffPolicy) {
        switch (backoffPolicy) {
            case LINEAR: {
                return JobRequest.BackoffPolicy.LINEAR;
            }
        }
        return JobRequest.BackoffPolicy.EXPONENTIAL;
    }

    private static JobRequest.NetworkType adaptNetworkType(UploadPolicy.NetworkType networkType) {
        switch (networkType) {
            case NONE: {
                return JobRequest.NetworkType.ANY;
            }
            case ANY: {
                return JobRequest.NetworkType.CONNECTED;
            }
            case UNMETERED: {
                return JobRequest.NetworkType.UNMETERED;
            }
        }
        return JobRequest.NetworkType.ANY;
    }

    @NonNull
    private static Job.Result adaptResult(UploadStatus res) {
        switch (res) {
            case FAILURE: {
                return Job.Result.FAILURE;
            }
            case SUCCESS: {
                return Job.Result.SUCCESS;
            }
            case RESCHEDULE: {
                return Job.Result.RESCHEDULE;
            }
        }
        return Job.Result.FAILURE;
    }

    @Override
    public void init(Context context) {
        JobManager.create((Context)context).addJobCreator((com.evernote.android.job.JobCreator)new JobCreator());
    }

    @Override
    public void doDispatch(UploadRequest request) {
        JobRequest job = AndroidJobStrategy.adapt(request);
        job.schedule();
    }

    @Override
    public void executeRequestsNow(int howMany) {
        int started = 0;
        for (JobRequest jobRequest : JobManager.instance().getAllJobRequests()) {
            if (this.isSoonButNotImmediate(jobRequest)) {
                JobRequest.Builder builder = jobRequest.cancelAndEdit();
                long endMillis = Math.max(jobRequest.getEndMs(), 60000L);
                builder.setExecutionWindow(10000L, endMillis).build().schedule();
                ++started;
            }
            if (started != howMany) continue;
            break;
        }
        Logger.d(TAG, String.format("Job scheduled started %d requests.", started));
    }

    private boolean isSoonButNotImmediate(JobRequest jobRequest) {
        return 60000L < jobRequest.getStartMs() && jobRequest.getStartMs() < 1800000L;
    }

    @Override
    public boolean cancelRequest(String requestId) {
        boolean cancelled = false;
        for (Job job : JobManager.instance().getAllJobs()) {
            String currJobId = ((UploadJob)job).requestId;
            if (!requestId.equals(currJobId)) continue;
            job.cancel();
            cancelled = true;
        }
        if (!cancelled) {
            for (Job job : JobManager.instance().getAllJobRequests()) {
                String id = job.getExtras().getString("requestId", null);
                if (!requestId.equals(id)) continue;
                cancelled = JobManager.instance().cancel(job.getJobId());
                break;
            }
        }
        this.killThread(requestId);
        Logger.i(TAG, String.format("Cancelling request %s, success: %s", requestId, cancelled));
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killThread(String requestId) {
        Object object = threadsMapLockObject;
        synchronized (object) {
            WeakReference<Thread> ref = threads.remove(requestId);
            if (ref != null) {
                Thread thread = (Thread)ref.get();
                if (thread != null) {
                    thread.interrupt();
                }
                ref.clear();
            }
        }
    }

    @Override
    public int cancelAllRequests() {
        Logger.i(TAG, "All requests cancelled.");
        int count = JobManager.instance().cancelAll();
        this.killAllThreads();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAllThreads() {
        Object object = threadsMapLockObject;
        synchronized (object) {
            for (String requestId : threads.keySet()) {
                WeakReference<Thread> ref = threads.get(requestId);
                Thread thread = (Thread)ref.get();
                if (thread != null) {
                    thread.interrupt();
                }
                ref.clear();
            }
            threads.clear();
        }
    }

    @Override
    public int getPendingImmediateJobsCount() {
        int pending = 0;
        for (JobRequest jobRequest : JobManager.instance().getAllJobRequests()) {
            if (!this.isImmediate(jobRequest)) continue;
            ++pending;
        }
        return pending;
    }

    private boolean isImmediate(JobRequest jobRequest) {
        return jobRequest.getStartMs() < 60000L;
    }

    @Override
    public int getRunningJobsCount() {
        int running = 0;
        for (Job job : JobManager.instance().getAllJobs()) {
            if (job.isFinished()) continue;
            ++running;
        }
        return running;
    }

    private static final class AndroidJobRequestParams
    implements RequestParams {
        private final PersistableBundleCompat bundle;

        private AndroidJobRequestParams(PersistableBundleCompat bundle) {
            this.bundle = bundle;
        }

        @Override
        public void putString(String key, String value) {
            this.bundle.putString(key, value);
        }

        @Override
        public void putInt(String key, int value) {
            this.bundle.putInt(key, value);
        }

        @Override
        public void putLong(String key, long value) {
            this.bundle.putLong(key, value);
        }

        @Override
        public void putBoolean(String key, boolean value) {
            this.bundle.putBoolean(key, value);
        }

        @Override
        public String getString(String key, String defaultValue) {
            return this.bundle.getString(key, defaultValue);
        }

        @Override
        public int getInt(String key, int defaultValue) {
            return this.bundle.getInt(key, defaultValue);
        }

        @Override
        public long getLong(String key, long defaultValue) {
            return this.bundle.getLong(key, defaultValue);
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            return this.bundle.getBoolean(key, defaultValue);
        }
    }

    private static final class UploadJob
    extends Job {
        private String requestId;

        UploadJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        protected Job.Result onRunJob(Job.Params params) {
            PowerManager pm = (PowerManager)this.getContext().getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, "CLD_UPLOADER");
            this.requestId = params.getExtras().getString("requestId", null);
            this.registerThread();
            wl.acquire();
            try {
                UploadStatus result = MediaManager.get().processRequest(this.getContext(), new AndroidJobRequestParams(params.getExtras()));
                Job.Result result2 = AndroidJobStrategy.adaptResult(result);
                return result2;
            }
            finally {
                wl.release();
                this.unregisterThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterThread() {
            Object object = threadsMapLockObject;
            synchronized (object) {
                WeakReference removed = (WeakReference)threads.remove(this.requestId);
                if (removed != null) {
                    removed.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerThread() {
            Object object = threadsMapLockObject;
            synchronized (object) {
                threads.put(this.requestId, new WeakReference<Thread>(Thread.currentThread()));
            }
        }
    }

    private static class JobCreator
    implements com.evernote.android.job.JobCreator {
        private JobCreator() {
        }

        public Job create(String tag) {
            return new UploadJob();
        }
    }
}

