/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.content.Context;
import com.cloudinary.android.ImmediateRequestsRunner;
import com.cloudinary.android.RequestParams;
import com.cloudinary.android.RequestProcessor;
import com.cloudinary.android.UploadRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultImmediateRequestsRunner
implements ImmediateRequestsRunner {
    private static final String TAG = "DefaultImmediateRequestsRunner";
    protected static final Map<String, Future> tasks = new ConcurrentHashMap<String, Future>();
    private final ExecutorService executor = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final RequestProcessor requestProcessor;

    DefaultImmediateRequestsRunner(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
    }

    @Override
    public synchronized void runRequest(final Context context, UploadRequest uploadRequest) {
        final ImmediateRequestParams params = new ImmediateRequestParams();
        uploadRequest.populateParamsFromFields(params);
        params.putBoolean("immediate", true);
        final String requestId = uploadRequest.getRequestId();
        tasks.put(requestId, this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultImmediateRequestsRunner.this.requestProcessor.processRequest(context, params);
                }
                finally {
                    tasks.remove(requestId);
                }
            }
        }));
    }

    @Override
    public synchronized boolean cancelRequest(String requestId) {
        Future task = tasks.remove(requestId);
        if (task != null) {
            task.cancel(true);
            return true;
        }
        return false;
    }

    @Override
    public synchronized int cancelAllRequests() {
        for (Future task : tasks.values()) {
            task.cancel(true);
        }
        int size = tasks.size();
        tasks.clear();
        return size;
    }

    private static final class ImmediateRequestParams
    implements RequestParams {
        private final Map<String, Object> map = new HashMap<String, Object>();

        private ImmediateRequestParams() {
        }

        @Override
        public void putString(String key, String value) {
            if (value == null) {
                this.map.remove(key);
            } else {
                this.map.put(key, value);
            }
        }

        @Override
        public void putInt(String key, int value) {
            this.map.put(key, value);
        }

        @Override
        public void putLong(String key, long value) {
            this.map.put(key, value);
        }

        @Override
        public void putBoolean(String key, boolean value) {
            this.map.put(key, value);
        }

        @Override
        public String getString(String key, String defaultValue) {
            return this.map.containsKey(key) ? this.map.get(key).toString() : null;
        }

        @Override
        public int getInt(String key, int defaultValue) {
            return this.map.containsKey(key) ? (Integer)this.map.get(key) : defaultValue;
        }

        @Override
        public long getLong(String key, long defaultValue) {
            return this.map.containsKey(key) ? (Long)this.map.get(key) : defaultValue;
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            return this.map.containsKey(key) ? (Boolean)this.map.get(key) : defaultValue;
        }
    }
}

