/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.content.Context;
import com.cloudinary.android.BackgroundRequestStrategy;
import com.cloudinary.android.ImmediateRequestsRunner;
import com.cloudinary.android.Logger;
import com.cloudinary.android.MediaManager;
import com.cloudinary.android.RequestDispatcher;
import com.cloudinary.android.UploadRequest;
import com.cloudinary.android.callback.ErrorInfo;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

class DefaultRequestDispatcher
implements RequestDispatcher {
    private static final String TAG = DefaultRequestDispatcher.class.getSimpleName();
    private final Random rand = new Random();
    private final BackgroundRequestStrategy strategy;
    private final ImmediateRequestsRunner immediateRequestsRunner;
    private final Set<String> abortedRequestIds = new HashSet<String>();
    private final Object cancellationLock = new Object();

    DefaultRequestDispatcher(BackgroundRequestStrategy strategy, ImmediateRequestsRunner immediateRequestsRunner) {
        this.strategy = strategy;
        this.immediateRequestsRunner = immediateRequestsRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String dispatch(UploadRequest request) {
        String requestId = request.getRequestId();
        int totalCount = this.strategy.getPendingImmediateJobsCount() + this.strategy.getRunningJobsCount();
        if (!request.getTimeWindow().isImmediate() && totalCount >= MediaManager.get().getGlobalUploadPolicy().getMaxConcurrentRequests()) {
            int minutes = 10 + this.rand.nextInt(10);
            request.defferByMinutes(minutes);
            Logger.d(TAG, String.format("Request %s deferred by %d minutes.", requestId, minutes));
        }
        Logger.d(TAG, String.format("Dispatching Request %s, scheduled start in %d minutes.", requestId, request.getTimeWindow().getMinLatencyOffsetMillis() / 60000L));
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.abortedRequestIds.remove(requestId)) {
                MediaManager.get().dispatchRequestError(null, requestId, new ErrorInfo(11, "Request cancelled"));
                return requestId;
            }
            this.strategy.doDispatch(request);
        }
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String startNow(Context context, UploadRequest request) {
        String requestId = request.getRequestId();
        Object object = this.cancellationLock;
        synchronized (object) {
            if (this.abortedRequestIds.remove(requestId)) {
                MediaManager.get().dispatchRequestError(null, requestId, new ErrorInfo(11, "Request cancelled"));
                return requestId;
            }
            this.immediateRequestsRunner.runRequest(context, request);
        }
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelRequest(String requestId) {
        Object object = this.cancellationLock;
        synchronized (object) {
            boolean cancelled = this.strategy.cancelRequest(requestId);
            if (!cancelled) {
                this.abortedRequestIds.add(requestId);
            }
            return cancelled;
        }
    }

    @Override
    public void queueRoomFreed() {
        int room = MediaManager.get().getGlobalUploadPolicy().getMaxConcurrentRequests() - this.strategy.getPendingImmediateJobsCount() - this.strategy.getRunningJobsCount();
        Logger.d(TAG, String.format("queueRoomFreed called, there's room for %d requests.", room));
        if (room > 0) {
            this.strategy.executeRequestsNow(room);
        }
    }

    @Override
    public int cancelAllRequests() {
        return this.strategy.cancelAllRequests();
    }
}

