/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.content.Context;
import android.support.annotation.NonNull;
import com.cloudinary.Cloudinary;
import com.cloudinary.ProgressCallback;
import com.cloudinary.android.CallbackDispatcher;
import com.cloudinary.android.ErrorRetrievingSignatureException;
import com.cloudinary.android.Logger;
import com.cloudinary.android.MediaManager;
import com.cloudinary.android.RequestParams;
import com.cloudinary.android.RequestProcessor;
import com.cloudinary.android.UploadRequest;
import com.cloudinary.android.callback.ErrorInfo;
import com.cloudinary.android.callback.UploadStatus;
import com.cloudinary.android.payload.EmptyByteArrayException;
import com.cloudinary.android.payload.FileNotFoundException;
import com.cloudinary.android.payload.LocalUriNotFoundException;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.PayloadFactory;
import com.cloudinary.android.payload.PayloadNotFoundException;
import com.cloudinary.android.payload.ResourceNotFoundException;
import com.cloudinary.android.signed.Signature;
import com.cloudinary.android.signed.SignatureProvider;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class DefaultRequestProcessor
implements RequestProcessor {
    private static final String TAG = "DefaultRequestProcessor";
    public static final String ERROR_COUNT_PARAM = "errorCount";
    private final CallbackDispatcher callbackDispatcher;
    private AtomicInteger runningJobs = new AtomicInteger(0);

    DefaultRequestProcessor(CallbackDispatcher callbackDispatcher) {
        this.callbackDispatcher = callbackDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadStatus processRequest(Context context, RequestParams params) {
        UploadStatus requestResultStatus;
        String requestId = params.getString("requestId", null);
        String uri = params.getString("uri", null);
        String optionsAsString = params.getString("options", null);
        int maxErrorRetries = params.getInt("maxErrorRetries", MediaManager.get().getGlobalUploadPolicy().getMaxErrorRetries());
        int errorCount = params.getInt(ERROR_COUNT_PARAM, 0);
        boolean isImmediate = params.getBoolean("immediate", false);
        Logger.i(TAG, String.format("Processing Request %s.", requestId));
        this.callbackDispatcher.dispatchStart(requestId);
        this.callbackDispatcher.wakeListenerServiceWithRequestStart(context, requestId);
        Context appContext = context.getApplicationContext();
        Map resultData = null;
        boolean optionsLoadedSuccessfully = false;
        HashMap<String, Object> options = null;
        try {
            options = StringUtils.isBlank((String)optionsAsString) ? new HashMap() : UploadRequest.decodeOptions(optionsAsString);
            optionsLoadedSuccessfully = true;
        }
        catch (Exception e) {
            Logger.e(TAG, String.format("Request %s, error loading options.", requestId), e);
        }
        ErrorInfo error = null;
        if (optionsLoadedSuccessfully) {
            if (StringUtils.isNotBlank((String)uri)) {
                Payload payload = PayloadFactory.fromUri(uri);
                if (payload != null) {
                    try {
                        this.runningJobs.incrementAndGet();
                        resultData = this.doProcess(requestId, appContext, options, params, payload);
                        requestResultStatus = UploadStatus.SUCCESS;
                    }
                    catch (FileNotFoundException e) {
                        Logger.e(TAG, String.format("FileNotFoundException for request %s.", requestId), e);
                        requestResultStatus = UploadStatus.FAILURE;
                        error = new ErrorInfo(1, e.getMessage());
                    }
                    catch (LocalUriNotFoundException e) {
                        Logger.e(TAG, String.format("LocalUriNotFoundException for request %s.", requestId), e);
                        requestResultStatus = UploadStatus.FAILURE;
                        error = new ErrorInfo(2, e.getMessage());
                    }
                    catch (ResourceNotFoundException e) {
                        Logger.e(TAG, String.format("ResourceNotFoundException for request %s.", requestId), e);
                        error = new ErrorInfo(3, e.getMessage());
                        requestResultStatus = UploadStatus.FAILURE;
                    }
                    catch (EmptyByteArrayException e) {
                        Logger.e(TAG, String.format("EmptyByteArrayException for request %s.", requestId), e);
                        requestResultStatus = UploadStatus.FAILURE;
                        error = new ErrorInfo(10, e.getMessage());
                    }
                    catch (ErrorRetrievingSignatureException e) {
                        Logger.e(TAG, String.format("Error retrieving signature for request %s.", requestId), e);
                        requestResultStatus = UploadStatus.FAILURE;
                        error = new ErrorInfo(4, e.getMessage());
                    }
                    catch (IOException e) {
                        if (e instanceof InterruptedIOException && !(e instanceof SocketTimeoutException)) {
                            Logger.e(TAG, String.format("InterruptedIO exception for request %s.", requestId), e);
                            error = new ErrorInfo(11, "Request cancelled.");
                            requestResultStatus = UploadStatus.FAILURE;
                        }
                        Logger.e(TAG, String.format("IOException for request %s.", requestId), e);
                        if (isImmediate) {
                            error = new ErrorInfo(5, e.getMessage());
                            requestResultStatus = UploadStatus.FAILURE;
                        }
                        if (errorCount >= maxErrorRetries) {
                            error = this.getMaxRetryError(errorCount);
                            requestResultStatus = UploadStatus.FAILURE;
                        }
                        params.putInt(ERROR_COUNT_PARAM, errorCount + 1);
                        error = new ErrorInfo(5, e.getMessage());
                        requestResultStatus = UploadStatus.RESCHEDULE;
                    }
                    catch (Exception e) {
                        Logger.e(TAG, String.format("Unexpected exception for request %s.", requestId), e);
                        error = new ErrorInfo(6, e.getMessage());
                        requestResultStatus = UploadStatus.FAILURE;
                    }
                    finally {
                        this.runningJobs.decrementAndGet();
                    }
                } else {
                    Logger.d(TAG, String.format("Failing request %s, payload cannot be loaded.", requestId));
                    error = new ErrorInfo(7, "Request payload could not be loaded.");
                    requestResultStatus = UploadStatus.FAILURE;
                }
            } else {
                requestResultStatus = UploadStatus.FAILURE;
                error = new ErrorInfo(8, "Request payload is empty.");
                Logger.d(TAG, String.format("Failing request %s, Uri is empty.", requestId));
            }
        } else {
            requestResultStatus = UploadStatus.FAILURE;
            error = new ErrorInfo(9, "Options could not be loaded.");
            Logger.d(TAG, String.format("Failing request %s, cannot load options.", requestId));
        }
        if (requestResultStatus.isFinal()) {
            if (requestResultStatus == UploadStatus.SUCCESS) {
                this.callbackDispatcher.dispatchSuccess(context, requestId, resultData);
            } else {
                this.callbackDispatcher.dispatchError(context, requestId, error);
            }
            this.callbackDispatcher.wakeListenerServiceWithRequestFinished(context, requestId, requestResultStatus);
        } else {
            this.callbackDispatcher.dispatchReschedule(context, requestId, error);
        }
        Logger.i(TAG, String.format("Finished processing request %s, result: %s", new Object[]{requestId, requestResultStatus}));
        return requestResultStatus;
    }

    @NonNull
    private ErrorInfo getMaxRetryError(int errorCount) {
        String message = String.format(Locale.getDefault(), "Request reached max retries allowed (%d).", errorCount);
        ErrorInfo error = new ErrorInfo(13, message);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map doProcess(String requestId, Context appContext, Map<String, Object> options, RequestParams params, Payload payload) throws PayloadNotFoundException, IOException, ErrorRetrievingSignatureException {
        SignatureProvider signatureProvider;
        String uploadUniqueId;
        int bufferSize;
        int defaultBufferSize;
        Logger.d(TAG, String.format("Starting upload for request %s", requestId));
        Object preparedPayload = payload.prepare(appContext);
        long actualTotalBytes = payload.getLength(appContext);
        long offset = params.getLong("offset", 0L);
        int n = defaultBufferSize = options.containsKey("chunk_size") ? (Integer)options.get("chunk_size") : 20000000;
        if (offset > 0L) {
            bufferSize = params.getInt("original_buffer_size", defaultBufferSize);
            uploadUniqueId = params.getString("original_upload_id", null);
        } else {
            bufferSize = ObjectUtils.asInteger((Object)options.get("chunk_size"), (Integer)defaultBufferSize);
            uploadUniqueId = new Cloudinary().randomPublicId();
        }
        if (!MediaManager.get().hasCredentials() && !Boolean.TRUE.equals(options.get("unsigned")) && (signatureProvider = MediaManager.get().getSignatureProvider()) != null) {
            try {
                Signature signature = signatureProvider.provideSignature(options);
                options.put("signature", signature.getSignature());
                options.put("timestamp", signature.getTimestamp());
                options.put("api_key", signature.getApiKey());
            }
            catch (Exception e) {
                throw new ErrorRetrievingSignatureException("Could not retrieve signature from the given provider: " + signatureProvider.getName(), e);
            }
        }
        ProcessorCallback processorCallback = new ProcessorCallback(actualTotalBytes, offset, this.callbackDispatcher, requestId);
        try {
            Map map = MediaManager.get().getCloudinary().uploader().uploadLarge(preparedPayload, options, bufferSize, offset, uploadUniqueId, (ProgressCallback)processorCallback);
            return map;
        }
        finally {
            params.putInt("original_buffer_size", bufferSize);
            params.putLong("offset", processorCallback.bytesUploaded - processorCallback.bytesUploaded % (long)bufferSize);
            params.putString("original_upload_id", uploadUniqueId);
        }
    }

    private static final class ProcessorCallback
    implements ProgressCallback {
        final long notifyThrottlingStepSize;
        private final CallbackDispatcher dispatcher;
        long bytesNotified;
        long bytesUploaded;
        long totalBytes;
        String requestId;

        ProcessorCallback(long totalBytes, long offset, CallbackDispatcher dispatcher, String requestId) {
            this.notifyThrottlingStepSize = totalBytes > 0L ? totalBytes / 100L : 512000L;
            this.totalBytes = totalBytes;
            this.bytesNotified = offset;
            this.bytesUploaded = offset;
            this.dispatcher = dispatcher;
            this.requestId = requestId;
        }

        public void onProgress(long bytes, long totalBytes) {
            this.bytesUploaded = bytes;
            if (this.bytesNotified + this.notifyThrottlingStepSize < bytes || totalBytes == this.totalBytes) {
                this.bytesNotified += this.notifyThrottlingStepSize;
                this.dispatcher.dispatchProgress(this.requestId, bytes, this.totalBytes);
            }
        }
    }
}

